/*!\file RheologyBbarx
 * \brief: compute Bbar for a certain element
 */

#include "./RheologyBbarx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void RheologyBbarx( double* prheology_bbar, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	

	extern int my_rank;
	int i;

	int found=0;
	int sumfound=0;
	int cpu_found=-1;
	int index;
	double rheology_bbar;


	/*retrieve element we are interested in: */
	parameters->FindParam(&index,IndexEnum);

	/*now, go through our elements, and retrieve the one with this id: index: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		if (element->Id()==index){
			found=1;
			cpu_found=my_rank;
			break;
		}
	}

	/*Broadcast whether we found the element: */
	MPI_Allreduce ( &found,&sumfound,1,MPI_INT,MPI_SUM,MPI_COMM_WORLD);
	if(!sumfound)_error_("%s%i%s","could not find material with id",index," to compute RheologyBbar");


	_error_("element->RheologyBbarx not implemented yet!");

	/*Ok, we found the material, compute Bbar: */
	if(my_rank==cpu_found){
		//rheology_bbar=element->RheologyBbarx();
	}

	/*Broadcast and plug into response: */
	MPI_Bcast(&rheology_bbar,1,MPI_DOUBLE,cpu_found,MPI_COMM_WORLD); 
	*prheology_bbar=rheology_bbar;
}
