/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void thermal_core(FemModel* femmodel){

	int i;

	/*intermediary*/
	double time;
	int    nsteps;
	double ndt;
	double dt;
	double melting_offset;
	bool control_analysis;
	int solution_type;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&ndt,NdtEnum);
	femmodel->parameters->FindParam(&dt,DtEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*Compute number of time steps: */
	if((dt==0)|| (ndt==0)){
		dt=0;
		nsteps=1;
	}
	else nsteps=(int)(ndt/dt);

	/*Loop through time: */
	for(i=0;i<nsteps;i++){
		
		if(nsteps)_printf_(VerboseSolution(),"time step: %i/%i\n",i+1,nsteps);
		time=(i+1)*dt;
		femmodel->parameters->SetParam(time,TimeEnum);

		/*call thermal_core_step: */
		thermal_core_step(femmodel,i,time);

		if(solution_type==ThermalSolutionEnum && !control_analysis){
			_printf_(VerboseSolution(),"   saving results\n");
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum,i+1,time);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BasalMeltingRateEnum,i+1,time);
		}

	}
}
