/*!\file Spc.h
 * \brief: header file for spc object
 */

#ifndef _SPC_H_
#define _SPC_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class DataSet;
/*}}}*/

class Spc: public Constraint{

	private: 
		int	sid; /*! id, to track it*/
		int	nodeid; /*!node id*/
		int dof; /*!component*/
		double value; /*value*/
		int analysis_type;

	public:

		/*Spc constructors, destructors:{{{1*/
		Spc();
		Spc(int sid,int nodeid, int dof,double value,int analysis_type);
		~Spc();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Constraint virtual functions definitions: {{{1*/
		void   ConstrainNode(Nodes* nodes,Parameters* parameters);
		bool   InAnalysis(int analysis_type);
		/*}}}*/
		/*Spc management:{{{1 */
		int    GetNodeId();
		int    GetDof();
		double GetValue();
		/*}}}*/

};

#endif  /* _SPC_H_ */
