/*
 * CreateConstraintsThermal.c:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsThermal(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int count;
	
	/*Output*/
	Constraints* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*return if 2d mesh*/
	if (iomodel->dim==2) goto cleanup_and_return;

	/*Create constraints: */
	IoModelToConstraintsx(constraints,iomodel,iomodel_handle,SpctemperatureEnum,ThermalAnalysisEnum);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
