
% This file can be run to check that the geothermal flux in simple conduction is correctly modeled.
% There is no velocity (no advection) the only thermal boundary conditions are an imposed temperature
% at upper surface and an impose flux at its base. The result must be a linear temperature from the upper to the lower
% surface with an imposed slope (Geothermal flux). if it is not the case, something is thermal modeling has been changed...
% Just run this file in Matlab, with a properly setup Ice code. 

% Create model;

md=model;
md=mesh(md,'DomainOutline.exp',100000);
md=geography(md,'','');
md=parameterize(md,'Square.par');
md=extrude(md,11,1);
md=setelementstype(md,'Pattyn','all');
thermalboundarycondition;

%analytical results
%the result is linear with depth and is equal to 0 on the upper surface (See BC)
%d2T/dz2=0  -k*dT/dz(bed)=G  T(surface)=0  => T=-G/k*(z-surface)
md.observed_temperature=-0.1/md.thermalconductivity*(md.z-md.surface); %G=0.1 W/m2

%modeled  results
md=solve(md,'analysis_type','thermal','sub_analysis_type','steady','package','cielo');

%plot results
relative=abs((md.results.thermal.temperature-md.observed_temperature)./md.observed_temperature)*100;
relative(find(md.results.thermal.temperature==md.observed_temperature))=0;
plotmodel(md,'data','temperature','title','modeled temperature','data','observed_temperature','view',3,'title','analytical temperature','view',3,'data',md.results.thermal.temperature-md.observed_temperature,'title','absolute error','view',3,'data',relative,'title','relative error [%]','view',3)
