% This file can be run to compare MacAyeal and Pattyn's model ie a 2d and a 3d model.
% This test deals with a  mesh includind an iceshelf ans an icesheet. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

%Compute solution for a Pattyn model
md=model;
md=mesh(md,'DomainOutline.exp',50000);
md=geography(md,'','');
md=parameterize(md,'Square.par');
md=extrude(md,5,3);
md=extrude(md,'Pattyn','all');

md=solve(md,'analysis_type','diagnostic','package','ice');
vel_pattyn=md.results.diagnostic.vel;
vx_pattyn=md.results.diagnostic.vx;
vy_pattyn=md.results.diagnostic.vy;
vz_pattyn=md.results.diagnostic.vz;
pressure_pattyn=md.results.diagnostic.pressure;

mdpattyn=md;
save modelpattyn mdpattyn;

%Compute solution for a Stokes model
md=model;
md=mesh(md,'DomainOutline.exp',50000);
md=geography(md,'','');
md=parameterize(md,'Square.par');
md=extrude(md,5,3);
md=extrude(md,'Pattyn','all','Stokes','all');

md=solve(md,'analysis_type','diagnostic','package','ice');
vel_stokes=md.results.diagnostic.vel;
vx_stokes=md.results.diagnostic.vx;
vy_stokes=md.results.diagnostic.vy;
vz_stokes=md.results.diagnostic.vz;
pressure_stokes=md.results.diagnostic.pressure;

mdstokes=md;
save modelstokes mdstokes;

