md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=none;

md.dt=1;
md.output_frequency=1;
md.ndt=4;

%Set up transient
smb = ones(md.numberofnodes,1)*3.6;
smb=[ smb smb*-1 ];

md.surface_mass_balance= smb;
md.surface_mass_balance(end+1,:)=[1.5 3];
md.isthermal=0;

md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SurfaceMassBalance1', ...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SurfaceMassBalance2', ...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SurfaceMassBalance3', ...
	'Vx4','Vy4','Vel4','Pressure4','Bed4','Surface4','Thickness4','SurfaceMassBalance4'};
field_tolerances={1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,1e-10};

field_values={...
	PatchToVec(md.results.TransientSolution(1).Vx),...
	PatchToVec(md.results.TransientSolution(1).Vy),...
	PatchToVec(md.results.TransientSolution(1).Vel),...
	PatchToVec(md.results.TransientSolution(1).Pressure),...
	PatchToVec(md.results.TransientSolution(1).Bed),...
	PatchToVec(md.results.TransientSolution(1).Surface),...
	PatchToVec(md.results.TransientSolution(1).Thickness),...
	PatchToVec(md.results.TransientSolution(1).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(2).Vx),...
	PatchToVec(md.results.TransientSolution(2).Vy),...
	PatchToVec(md.results.TransientSolution(2).Vel),...
	PatchToVec(md.results.TransientSolution(2).Pressure),...
	PatchToVec(md.results.TransientSolution(2).Bed),...
	PatchToVec(md.results.TransientSolution(2).Surface),...
	PatchToVec(md.results.TransientSolution(2).Thickness),...
	PatchToVec(md.results.TransientSolution(2).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(3).Vx),...
	PatchToVec(md.results.TransientSolution(3).Vy),...
	PatchToVec(md.results.TransientSolution(3).Vel),...
	PatchToVec(md.results.TransientSolution(3).Pressure),...
	PatchToVec(md.results.TransientSolution(3).Bed),...
	PatchToVec(md.results.TransientSolution(3).Surface),...
	PatchToVec(md.results.TransientSolution(3).Thickness),...
	PatchToVec(md.results.TransientSolution(3).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(4).Vx),...
	PatchToVec(md.results.TransientSolution(4).Vy),...
	PatchToVec(md.results.TransientSolution(4).Vel),...
	PatchToVec(md.results.TransientSolution(4).Pressure),...
	PatchToVec(md.results.TransientSolution(4).Bed),...
	PatchToVec(md.results.TransientSolution(4).Surface),...
	PatchToVec(md.results.TransientSolution(4).Thickness),...
	PatchToVec(md.results.TransientSolution(4).SurfaceMassBalance),...
	};
