/*
 * UpdateElementsAndMaterialsControl:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsAndMaterialsControl(Elements* elements,Materials* materials, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int       i;
	int       counter;
	Element  *element = NULL;
	Material *material = NULL;

	/*Now, return if no control*/
	if (!iomodel->control_analysis) return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	IoModelToInputsx(elements,iomodel,iomodel_handle,VxObsEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyObsEnum); 
	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessObsEnum);

	IoModelFetchData(&iomodel->control_type,NULL,NULL,iomodel_handle,ControlTypeEnum);
	IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,WeightsEnum);
	IoModelFetchData(&iomodel->cm_min,NULL,NULL,iomodel_handle,CmMinEnum);
	IoModelFetchData(&iomodel->cm_max,NULL,NULL,iomodel_handle,CmMaxEnum);
	for(i=0;i<iomodel->num_control_type;i++){
		switch((int)iomodel->control_type[i]){
			case DhdtEnum:
				IoModelFetchData(&iomodel->dhdt,NULL,NULL,iomodel_handle,DhdtEnum);
				break;
			case VxEnum:
				IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,VxEnum);
				break;
			case VyEnum:
				IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,VyEnum);
				break;
			case DragCoefficientEnum:
				IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,DragCoefficientEnum);
				break;
			case RheologyBbarEnum:
				IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,RheologyBEnum);
				break;
			default:
				_error_("Control %s not implemented yet",EnumToStringx((int)iomodel->control_type[i]));
		}
	}

	/*Update elements and materials: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.

			material=(Material*)materials->GetObjectByOffset(counter);
			material->InputUpdateFromIoModel(i,iomodel); //we need i to index into elements.
			counter++;
		}
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->weights);
	xfree((void**)&iomodel->cm_min);
	xfree((void**)&iomodel->cm_max);
	xfree((void**)&iomodel->control_type);
	xfree((void**)&iomodel->dhdt);
	xfree((void**)&iomodel->vx);
	xfree((void**)&iomodel->vy);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->rheology_B);
}
