/*!\file PentaVertexElementResult.c
 * \brief: implementation of the PentaVertexElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*PentaVertexElementResult constructors and destructor*/
/*FUNCTION PentaVertexElementResult::PentaVertexElementResult(){{{1*/
PentaVertexElementResult::PentaVertexElementResult(){
	return;
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::PentaVertexElementResult(int in_enum_type,double* in_values,int in_step, double in_time){{{1*/
PentaVertexElementResult::PentaVertexElementResult(int in_enum_type,double* in_values,int in_step, double in_time){

	int i;

	enum_type=in_enum_type;
	for(i=0;i<6;i++)values[i]=in_values[i];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::~PentaVertexElementResult(){{{1*/
PentaVertexElementResult::~PentaVertexElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION PentaVertexElementResult::Echo {{{1*/
void PentaVertexElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::DeepEcho{{{1*/
void PentaVertexElementResult::DeepEcho(void){

	printf("PentaVertexElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   values: [%g %g %g %g %g %g]\n",this->values[0],this->values[1],this->values[2],this->values[3],this->values[4],this->values[5]);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);

}
/*}}}*/
/*FUNCTION PentaVertexElementResult::Id{{{1*/
int    PentaVertexElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION PentaVertexElementResult::MyRank{{{1*/
int    PentaVertexElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::Marshall{{{1*/
void  PentaVertexElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of PentaVertexElementResult: */
	enum_value=PentaVertexElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall PentaVertexElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&values,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::MarshallSize{{{1*/
int   PentaVertexElementResult::MarshallSize(){
	
	return sizeof(values)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::Demarshall{{{1*/
void  PentaVertexElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&values,marshalled_dataset,sizeof(values));marshalled_dataset+=sizeof(values);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::Enum{{{1*/
int PentaVertexElementResult::Enum(void){

	return PentaVertexElementResultEnum;

}
/*}}}*/
/*FUNCTION PentaVertexElementResult::copy{{{1*/
Object* PentaVertexElementResult::copy() {
	
	return new PentaVertexElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION PentaVertexElementResult::EnumType{{{1*/
int PentaVertexElementResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION PentaVertexElementResult::SpawnTriaElementResult{{{1*/
ElementResult* PentaVertexElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaVertexElementResult* outresult=NULL;
	double newvalues[3];

	/*Loop over the new indices*/
	for(int i=0;i<3;i++){

		/*Check index value*/
		_assert_(indices[i]>=0 && indices[i]<6);

		/*Assign value to new result*/
		newvalues[i]=this->values[indices[i]];
	}

	/*Create new Tria result*/
	outresult=new TriaVertexElementResult(this->enum_type,&newvalues[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION PentaVertexElementResult::ProcessUnits{{{1*/
void PentaVertexElementResult::ProcessUnits(Parameters* parameters){
	
	UnitConversion(this->values,6,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION PentaVertexElementResult::NumberOfNodalValues{{{1*/
int PentaVertexElementResult::NumberOfNodalValues(void){
	return 6;
}
/*}}}*/
/*FUNCTION PentaVertexElementResult::PatchFill{{{1*/
void PentaVertexElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,6);

}
/*}}}*/
