/*!\file DoubleElementResult.c
 * \brief: implementation of the DoubleElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "./ElementResultLocal.h"
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*DoubleElementResult constructors and destructor*/
/*FUNCTION DoubleElementResult::DoubleElementResult(){{{1*/
DoubleElementResult::DoubleElementResult(){
	return;
}
/*}}}*/
/*FUNCTION DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){{{1*/
DoubleElementResult::DoubleElementResult(int in_enum_type,IssmDouble in_value,int in_step, double in_time){

	enum_type=in_enum_type;
	value=in_value;
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION DoubleElementResult::~DoubleElementResult(){{{1*/
DoubleElementResult::~DoubleElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DoubleElementResult::Echo {{{1*/
void DoubleElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleElementResult::DeepEcho{{{1*/
void DoubleElementResult::DeepEcho(void){

	printf("DoubleElementResult:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumToStringx(this->enum_type));
	printf("   value: %g\n",this->value);
	printf("   step: %i\n",this->step);
	printf("   time: %g\n",this->time);
}
/*}}}*/
/*FUNCTION DoubleElementResult::Id{{{1*/
int    DoubleElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleElementResult::MyRank{{{1*/
int    DoubleElementResult::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleElementResult::Marshall{{{1*/
void  DoubleElementResult::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleElementResult: */
	enum_value=DoubleElementResultEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleElementResult data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(marshalled_dataset,&time,sizeof(time));marshalled_dataset+=sizeof(time);
	memcpy(marshalled_dataset,&step,sizeof(step));marshalled_dataset+=sizeof(step);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleElementResult::Demarshall{{{1*/
void  DoubleElementResult::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);
	memcpy(&step,marshalled_dataset,sizeof(step));marshalled_dataset+=sizeof(step);
	memcpy(&time,marshalled_dataset,sizeof(time));marshalled_dataset+=sizeof(time);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleElementResult::Enum{{{1*/
int DoubleElementResult::Enum(void){

	return DoubleElementResultEnum;

}
/*}}}*/
/*FUNCTION DoubleElementResult::copy{{{1*/
Object* DoubleElementResult::copy() {

	return new DoubleElementResult(this->enum_type,this->value,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION DoubleElementResult::MarshallSize{{{1*/
int   DoubleElementResult::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)
		+sizeof(time)
		+sizeof(step)
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleElementResult::EnumType{{{1*/
int DoubleElementResult::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleElementResult::SpawnTriaElementResult{{{1*/
ElementResult* DoubleElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	DoubleElementResult* outresult=new DoubleElementResult();

	/*copy fields: */
	outresult->enum_type=this->enum_type;
	outresult->value=this->value;
	outresult->time=this->time;
	outresult->step=this->step;

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION DoubleElementResult::ProcessUnits{{{1*/
void DoubleElementResult::ProcessUnits(Parameters* parameters){
	
	this->value=UnitConversion(this->value,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION DoubleElementResult::NumberOfNodalValues{{{1*/
int DoubleElementResult::NumberOfNodalValues(void){
	return 1;
}
/*}}}*/
/*FUNCTION DoubleElementResult::PatchFill{{{1*/
void DoubleElementResult::PatchFill(int row, Patch* patch){
	
	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P0Enum,&this->value,1);

}
/*}}}*/
