/*
 * UpdateElementsSurfaceSlope:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsSurfaceSlope(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	
	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
	}
	
	/*Free data: */
	xfree((void**)&iomodel->elements);

}
