/*
 * UpdateElementsMelting:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsMelting(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	/*Create inputs: */
	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragCoefficientEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragPEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragQEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementsTypeEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyBEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyNEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAccumulationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAblationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceMassBalanceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,PressureEnum);
	
	/*Free data: */
	xfree((void**)&iomodel->elements);

}
