/*
 * UpdateElementsHydrology:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../modules/modules.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsHydrology(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragCoefficientEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragPEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragQEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementsTypeEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyBEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyNEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,PressureEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,TemperatureEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,WatercolumnEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,GeothermalfluxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VzEnum);

	elements->InputDuplicate(WatercolumnEnum,WaterColumnOldEnum);
	elements->InputDuplicate(WatercolumnEnum,WaterColumnPicardEnum);
	
	/*Free data: */
	xfree((void**)&iomodel->elements);

	
}
