/*
 * UpdateElementsBalancethickness:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../modules/modules.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsBalancethickness(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);

	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VxEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAccumulationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAblationRateEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceMassBalanceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DhdtEnum);

	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
	}
	/*Free data: */
	xfree((void**)&iomodel->elements);


}
