/*\file diskio.h
 *\brief: I/O for ISSM from disk
 */

#ifndef _DISK_IO_H_
#define _DISK_IO_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

void  IoModelFetchData(bool*     pboolean,FILE* model_handle,int data_enum);
void  IoModelFetchData(int*      pinteger,FILE* model_handle,int data_enum);
void  IoModelFetchData(double*   pscalar,FILE* model_handle,int data_enum);
void  IoModelFetchData(char**    pstring,FILE* model_handle,int data_enum);
void  IoModelFetchData(double**  pscalarmatrix,int* pM,int* pN,FILE* model_handle,int data_enum);
void  IoModelFetchData(char***   pstringarray,int* pnumstrings,FILE* model_handle,int data_enum);
void  IoModelFetchData(double*** pmatrixarray,int** pmdims,int** pndims, int* pnumrecords,FILE* model_handle,int data_enum);

FILE* SetFilePointerToData(int* pcode,int* pvector_type, FILE* model_handle,int data_enum);

#endif	/* _IO_H_ */
