/*
 * UpdateElementsDiagnosticHoriz:
 */

#include "../../../Container/Container.h"
#include "../../../modules/modules.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsDiagnosticHoriz(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int      i;
	int      counter;
	Element *element = NULL;

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,ElementsTypeEnum);

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Create inputs: */
	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ThicknessCoeffEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BedEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragCoefficientEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragPEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragQEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,DragTypeEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnIceShelfEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnWaterEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyBEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,RheologyNEnum);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VxEnum,VxObsEnum,0);
	IoModelToInputsx(elements,iomodel,iomodel_handle,VyEnum,VyObsEnum,0);
	IoModelToInputsx(elements,iomodel,iomodel_handle,BathymetryEnum);

	if (iomodel->dim==3){
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnBedEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,ElementOnSurfaceEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,VzEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAccumulationRateEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceAblationRateEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,SurfaceMassBalanceEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,BasalMeltingRateEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,NodeOnStokesEnum);
	}

	if(iomodel->control_analysis){
		IoModelToInputsx(elements,iomodel,iomodel_handle,VxObsEnum);
		IoModelToInputsx(elements,iomodel,iomodel_handle,VyObsEnum);
	}

	/*Post-process: */

	elements->InputDuplicate(VxEnum,VxPicardEnum);
	elements->InputDuplicate(VxEnum,VxObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VxEnum,QmuVxEnum);
	
	elements->InputDuplicate(VyEnum,VyPicardEnum);
	elements->InputDuplicate(VyEnum,VyObsEnum);
	if(iomodel->qmu_analysis)elements->InputDuplicate(VyEnum,QmuVyEnum);
	
	if(iomodel->dim==3){
		elements->InputDuplicate(VzEnum,VzPicardEnum);
		elements->InputDuplicate(VzEnum,VzObsEnum);
		if(iomodel->qmu_analysis)elements->InputDuplicate(VzEnum,QmuVzEnum);
	}

	
	cleanup_and_return:
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elements_type);
}
