function responses=SpawnCore(femmodel,variables,variabledescriptors,counter);
%SPAWNCORE - for Qmu analysis, using Dakota. Spawn the core solution.
%
%   Usage:
%      responses=SpawnCore(femmodel,variables,variabledescriptors)
%

%retrieve parameters
responsedescriptors=femmodel.parameters.Responsedescriptors; 
solution_type=femmodel.parameters.SolutionType;
control_analysis=femmodel.parameters.ControlAnalysis;
qmu_save_femmodel=femmodel.parameters.QmuSaveFemmodel;

issmprintf(VerboseQmu(),'%s%i',['   qmu iteration:'],counter);

%first update the inputs to the femmodel using the variables provided to us by dakota.
[femmodel.elements femmodel.loads femmodel.materials]=InputUpdateFromDakota(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,variables,variabledescriptors);

%now run the core solution
[dummy,dummy,solutioncore]=SolutionConfiguration(solution_type);
if(control_analysis)solutioncore='control_core';end;
eval(['femmodel=' solutioncore '(femmodel);']);

%now process the results to get response function values
responses=DakotaResponses(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,responsedescriptors);

if qmu_save_femmodel
    issmprintf(VerboseQmu(),'%s%i%s',['   writing femmodel to femmodel_spawncorem_'],counter,['.mat']);
    save(sprintf('femmodel_spawncorem_%i',counter),'femmodel');
end

