function WriteData(fid,data,data_type,enum)
%WRITEDATA - ...
%
%   Usage:
%      WriteData(fid,data,data_type,enum)
%
%   Eg: WriteData(fid,md.elementoniceshelf,'Mat',ElementOnIceShelfEnum);

if issparse(data),
	data=full(data);
end

%Ok! put the length of the name, and the "name" string first!
fwrite(fid,enum,'int'); 

if strcmpi(data_type,'String'),
	%first write length of record
	fwrite(fid,length(data)+4,'int');  %4 for int32
	%now write string
	fwrite(fid,length(data),'int'); 
	fwrite(fid,data,'char'); 
elseif strcmpi(data_type,'Mat'),
	%Get size
	s=size(data);
	%if matrix = NaN, then do not write anything
	if (s(1)==1 & s(2)==1 & isnan(data)),
		s(1)=0; s(2)=0;
	end
	
	%first write length of record
	fwrite(fid,4+4+8*s(1)*s(2),'int');  %2 integers (32 bits) + the double matrix

	%now write matrix
	fwrite(fid,s(1),'int'); 
	fwrite(fid,s(2),'int'); 
	if s(1)*s(2),
		fwrite(fid,data','double'); %get to the "c" convention, hence the transpose
	end
elseif strcmpi(data_type,'Integer'),
	%first write length of record
	fwrite(fid,4,'int');  %1 integer

	%now write integer
	fwrite(fid,data,'int'); 
elseif strcmpi(data_type,'Scalar'),
	%first write length of record
	fwrite(fid,8,'int');  %1 double
	%now write double
	fwrite(fid,data,'double'); 
elseif strcmpi(data_type,'StringArray'),

	%first get length of string array: 
	num=numel(data);
	%now get length of record: 
	recordlength=4; %for length of array
	for i=1:num,
		string=data{i};
		recordlength=recordlength+4+length(string); %for each string
	end

	%write length of record
	fwrite(fid,recordlength,'int'); 

	%now write length of string array
	fwrite(fid,num,'int'); 
	
	%now write the strings
	for i=1:num,
		string=data{i};
		fwrite(fid,length(string),'int'); 
		fwrite(fid,string,'char'); 
	end
elseif strcmpi(data_type,'MatArray'),

	numrecords=numel(data);
	
	%first get length of record
	recordlength=4; %number of records=
	for i=1:numrecords,
		matrix=data{i};
		s=size(matrix);
		recordlength=recordlength+4*2+... %row and col of matrix
					 s(1)*s(2)*8; %matrix of doubles
	end

	%write length of record
	fwrite(fid,recordlength,'int'); 

	%write data, first number of records
	fwrite(fid,numrecords,'int'); 
	
	%write each matrix: 
	for i=1:numrecords,
		matrix=data{i};
		s=size(matrix);
		fwrite(fid,s(1),'int'); 
		fwrite(fid,s(2),'int'); 
		fwrite(fid,matrix,'double');
	end
else 
	error('WriteData error message: data type not supported yet!');
end
