/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

#include "../modules/EnumToStringx/EnumToStringx.h"
#include "../modules/StringToEnumx/StringToEnumx.h"

enum definitions{
	/*Datasets {{{1*/
	ConstraintsEnum,
	DatasetsEnum,
	ElementsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ParametersEnum,
	ResultsEnum,
	VerticesEnum,
	/*}}}*/
	/*Solution types {{{1 */
	SolutionTypeEnum,
	/*}}}*/
	/*Analysis types {{{1 */
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AnalysisCounterEnum,
	//diagnostic
	DiagnosticSolutionEnum,
	DiagnosticAnalysisEnum,
	DiagnosticHorizAnalysisEnum,
	DiagnosticVertAnalysisEnum,
	DiagnosticHutterAnalysisEnum,
	//control
	AdjointSolutionEnum,
	AdjointHorizAnalysisEnum,
	AdjointBalancethicknessAnalysisEnum,
	ControlAnalysisEnum,
	GradientAnalysisEnum,
	InverseAnalysisEnum,
	//thermal
	ThermalSolutionEnum,
	ThermalAnalysisEnum,
	//hydro
	HydrologySolutionEnum,
	HydrologyAnalysisEnum,
	//transient
	TransientSolutionEnum,
	GroundingLineMigration2DSolutionEnum,
	SteadyAnalysisEnum,
	TransientAnalysisEnum, // needed by nighly run (to be removed at some point?)
	//slope
	BedSlopeSolutionEnum,
	BedSlopeAnalysisEnum,
	SurfaceSlopeSolutionEnum,
	SurfaceSlopeAnalysisEnum,
	BedSlopeXAnalysisEnum,
	BedSlopeYAnalysisEnum,
	SurfaceSlopeXAnalysisEnum,
	SurfaceSlopeYAnalysisEnum,
	//prognostic
	BalancethicknessSolutionEnum,
	BalancethicknessAnalysisEnum,
	BalancevelocitiesSolutionEnum,
	BalancevelocitiesAnalysisEnum,
	PrognosticSolutionEnum,
	PrognosticAnalysisEnum,
	//melting
	MeltingAnalysisEnum,
	//parameters
	ParametersSolutionEnum,
	ParametersAnalysisEnum,
	//steadystate
	SteadystateSolutionEnum,
	SteadystateAnalysisEnum,
	//flaim
	FlaimSolutionEnum,
	FlaimAnalysisEnum,
	//none
	NoneAnalysisEnum,
	/*}}}*/
	/*Approximations {{{1*/
	ApproximationEnum,
	HutterApproximationEnum,
	MacAyealApproximationEnum,
	MacAyealPattynApproximationEnum,
	MacAyealStokesApproximationEnum,
	NoneApproximationEnum,
	PattynApproximationEnum,
	PattynStokesApproximationEnum,
	StokesApproximationEnum,
	/*}}}*/
	/*Objects {{{1*/
	ObjectEnum,
	HookEnum,
	SegmentEnum,
	/*Elements: */
	ElementEnum,
	DofIndexingEnum,
	ElementPropertiesEnum,
	NodePropertiesEnum,
	PentaEnum,
	TriaEnum,
	/*Nodes: */
	NodeEnum,
	VertexEnum,
	/*Loads: */
	LoadEnum,
	IcefrontEnum,
	NumericalfluxEnum,
	PengridEnum,
	PenpairEnum,
	QuadRiftFrontEnum,
	RiftfrontEnum,
	SegmentRiftfrontEnum,
	MacAyeal2dIceFrontEnum,
	MacAyeal3dIceFrontEnum,
	PattynIceFrontEnum,
	StokesIceFrontEnum,
	/*Materials: */
	MaterialEnum,
	MaticeEnum,
	MatparEnum,
	/*Inputs: */
	InputEnum,
	BoolInputEnum,
	DoubleInputEnum,
	IntInputEnum,
	PentaVertexInputEnum,
	TriaVertexInputEnum,
	TriaVertexForcingEnum, //TO BE DELETED (not used anymore)
	PentaVertexForcingEnum, //TO BE DELETED (not used anymore)
	ControlInputEnum,
	/*Params: */
	ParamEnum,
	BoolParamEnum,
	DoubleMatParamEnum,
	DoubleMatArrayParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	IntParamEnum,
	IntVecParamEnum,
	FileParamEnum,
	PetscMatParamEnum,
	PetscVecParamEnum,
	StringArrayParamEnum,
	StringParamEnum,
	/*Results: */
	ElementResultEnum,
	ExternalResultEnum,
	/*Spc: */
	SpcEnum,
	/*}}}*/
	/*Geography {{{1*/
	GeographyEnum,
	IceSheetEnum,
	IceShelfEnum,
	/*}}}*/
	/*Fill {{{1*/
	WaterEnum,
	IceEnum,
	AirEnum,
	MelangeEnum,
	/*}}}*/
	/*Rift state {{{1*/
	FreeEnum,
	OpenEnum,
	ClosedEnum,
	/*}}}*/
	/*Inputs {{{1*/
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	AdjointpEnum,
	ArtDiffEnum,
	BedEnum,
	BathymetryEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	CmResponseEnum,
	CmResponsesEnum,
	CmNoiseDmpEnum, //TO BE DELETED (not used anymore)
	ConstantEnum,
	NumControlsEnum,
	ControlTypeEnum,
	ConvergedEnum,
	DhDtEnum,  //TO BE DELETED 
	DragCoefficientEnum,
	DragPEnum,
	DragQEnum,
	DragTypeEnum,
	DtEnum,
	TimeAdaptEnum,
	CflCoefficientEnum,
	ElementOnBedEnum,
	ElementOnIceShelfEnum,
	ElementOnSurfaceEnum,
	ElementOnWaterEnum,
	EpsVelEnum,  //TO BE DELETED 
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GeothermalFluxEnum, //TO BE DELETED 
	HydrostaticAdjustmentEnum,
	InternalEnum,
	KflagEnum,
	IuToExtEnum,
	ExtToIuEnum,
	MassFluxEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceAverageVelMisfitEnum,
	MaxPenetrationEnum,
	MeanVelEnum, //TO BE DELETED 
	MeltingOffsetEnum,
	GroundingLineMeltingRateEnum,
	BasalMeltingRateEnum,
	MisfitEnum,
	NodeOnBedEnum,
	NodeOnIceSheetEnum,
	NodeOnIceShelfEnum,
	NodeOnSurfaceEnum,
	NumberNodeToElementConnectivityEnum,
	PenaltyOffsetEnum,
	PflagEnum,
	PressureEnum,
	PressurePicardEnum,
	VelocityEnum,
	QmuPressureEnum,
	ResetPenaltiesEnum,
	RheologyBEnum,
	RheologyBbarEnum,
	RheologyNEnum,
	SegmentOnIceShelfEnum,
	ShelfDampeningEnum,
	StabilizeConstraintsEnum,
	StokesReconditioningEnum,  //TO BE DELETED
	SurfaceAccumulationRateEnum,
	SurfaceAblationRateEnum,
	SurfaceAreaEnum,
	SurfaceEnum,
	SurfaceMassBalanceEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperatureOldEnum,
	ThicknessEnum,
	ThicknessCoeffEnum,
	ThicknessObsEnum,
	TypeEnum,
	VelEnum,
	VelObsEnum,
	ViscosityOvershootEnum,
	VxAverageEnum,
	VxEnum,
	VxObsEnum,
	VxPicardEnum,
	QmuVxEnum,
	VyAverageEnum,
	VyEnum,
	VyObsEnum,
	VyPicardEnum,
	QmuVyEnum,
	VzAverageEnum,
	VzEnum,
	VzObsEnum,
	VzPicardEnum,
	VzMacAyealEnum,
	VzPattynEnum,
	VzStokesEnum,
	QmuVzEnum,
	WeightsEnum,
	/*}}}*/
	/*Element types{{{1*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	MiniEnum,
	/*}}}*/
	/*Results{{{1*/
	DoubleElementResultEnum,
	TriaVertexElementResultEnum,
	PentaVertexElementResultEnum,
	BoolElementResultEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleVecExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	PetscVecExternalResultEnum,
	StringExternalResultEnum,
	JEnum,
	PatchEnum,
	PatchVerticesEnum,
	PatchNodesEnum,
	TimeEnum,
	OutputFrequencyEnum,
	WaterColumnEnum, //TO BE DELETED
	WaterColumnOldEnum,
	WaterColumnPicardEnum,
	/*}}}*/
	/*Io{{{1*/
	IoGatherEnum,
	/*}}}*/
	/*Responses{{{1*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	/*}}}*/
	/*Convergence{{{1*/
	RelativeEnum,
	ResidualEnum,
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{1*/
	NoneEnum,
	AgressiveMigrationEnum,
	SoftMigrationEnum,
	/*}}}*/
	/*Material{{{1*/
	RhoIceEnum,
	RhoWaterEnum,
	GravityEnum,
	ThermalConductivityEnum, //TO BE DELETED
	BasalMeltingRateCorrectionEnum,
	BasalMeltingRateCorrectionApplyEnum,
	MixedLayerCapacityEnum,
	ThermalExchangeVelocityEnum,
	/*}}}*/
	/*Solver{{{1*/
	StokesSolverEnum,
	/*}}}*/
	/*Parameters{{{1*/
	IntersectEnum,
	ColinearEnum,
	SeparateEnum,
	BetaEnum,
	CmGradientEnum,
	CmJumpEnum,
	CmMaxEnum,
	CmMinEnum,
	AdjointEnum,
	GradientEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	OldGradientEnum,
	ConnectivityEnum,
	ControlSteadyEnum,
	DakotaParameterEnum,
	DimEnum,
	EpsAbsEnum,
	EpsCmEnum,
	EpsRelEnum,
	EpsResEnum,
	HeatCapacityEnum,   //TO BE DELETED
	IsHutterEnum, //TO BE DELETED
	IsMacAyealPattynEnum, //TO BE DELETED
	IsStokesEnum, //TO BE DELETED
	KffEnum, //TO BE DELETED
	LatentHeatEnum, //TO BE DELETED
	LowmemEnum,
	MaxIterEnum, //TO BE DELETED
	MaxNonlinearIterationsEnum,
	MeltingPointEnum, //TO BE DELETED
	MinMechanicalConstraintsEnum,
	MinThermalConstraintsEnum,
	NStepsEnum, //TO BE DELETED
	NdtEnum,
	NumOutputEnum,
	NumRiftsEnum,
	NumberOfElementsEnum,
	NumberOfNodesEnum,
	NumberOfVerticesEnum,
	OptScalEnum, //TO BE DELETED
	OutputFilePointerEnum,
	OutputFileNameEnum, //TO BE DELETED
	ParameterOutputEnum, //TO BE DELETED
	PenaltyMeltingEnum,
	QmuAnalysisEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuMassFluxSegmentsEnum,
	QmuNPartEnum,
	QmuOutNameEnum,
	QmuPartEnum,
	QmuNumberOfResponsesEnum,
	QmuSaveFemmodelEnum,
	IndexedEnum,
	RegularEnum,
	IndexEnum,
	ScaledEnum,
	NodalEnum,
	ResponseDescriptorsEnum,
	PetscRcEnum,
	SparsityEnum,
	TolXEnum, //TO BE DELETED
	VariableDescriptorsEnum,
	VerboseEnum,
	WaitOnLockEnum, //TO BE DELETED
	PetscOptionsStringsEnum,
	PetscOptionsAnalysesEnum,
	GsetEnum,
	FsetEnum,
	SsetEnum,
	GroundingLineMigrationEnum,
	YtsEnum,
	/*}}}*/
	/*Interpolation {{{1*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Options{{{1*/
	OptionEnum,
	OptionCellEnum,
	OptionCharEnum,
	OptionDoubleEnum,
	OptionLogicalEnum,
	OptionStructEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{1*/
	RheologyLawEnum,
	PatersonEnum,
	ArrheniusEnum,
	/*}}}*/
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	IsDiagnosticEnum, //TO BE DELETED
	IsPrognosticEnum, //TO BE DELETED
	IsThermalEnum, //TO BE DELETED
	EnthalpySolutionEnum,
	EnthalpyAnalysisEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	WaterFractionEnum, //TO BE DELETED
	ReferenceTemperatureEnum, //TO BE DELETED
	ThicknessAbsGradientEnum,
	VelAbsGradientEnum,
	DatasetInputEnum,
	NumResponsesEnum,
	StepResponsesEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	/*Temporary*/
	NumberOfElements2DEnum,
	NumControlTypeEnum,
	SpcvyEnum,
	HydroQEnum,
	VerboseBinaryEnum,
	NodeOnWaterEnum,
	YEnum,
	GlMeltingRateEnum,
	ElementsTypeEnum,
	PenaltiesEnum,
	PrognosticDGEnum,
	PressureloadEnum,
	HydroCREnum,
	NameEnum,
	VerticesTypeEnum,
	HydroKnEnum,
	GEnum,
	InputfilenameEnum,
	SpcvzEnum,
	list,
	NumberOfNodes2DEnum,
	NodeOnStokesEnum,
	NodeOnHutterEnum,
	ZEnum,
	GlMigrationEnum,
	RiftinfoEnum,
	ElementOnIceSheetEnum,
	SpcthicknessEnum,
	SpctemperatureEnum,
	PenaltyLockEnum,
	SpcvxEnum,
	UpperelementsEnum,
	HydroPEnum,
	NodeOnPattynEnum,
	EdgesEnum,
	Elements2DEnum,
	XEnum,
	NumCmResponsesEnum,
	NodeOnMacayealEnum,
	ElementconnectivityEnum,
	SpcwatercolumnEnum,
	ArtificialDiffusivityEnum,
	HydroNEnum,
	BorderstokesEnum,
	NumlayersEnum,
	DiagnosticRefEnum,
	IshutterEnum,
	IsmacayealpattynEnum,
	IsstokesEnum,
	StokesreconditioningEnum,
	LowerelementsEnum,
	HeatcapacityEnum,
	LatentheatEnum,
	ThermalconductivityEnum,
	MeltingpointEnum,
	ReferencetemperatureEnum,
	DhdtEnum,
	GeothermalfluxEnum,
	IsprognosticEnum,
	IsdiagnosticEnum,
	IsthermalEnum,
	NstepsEnum,
	MaxiterEnum,
	TolxEnum,
	OptscalEnum,
	EpsvelEnum,
	MeanvelEnum,
	ParameteroutputEnum,
	OutputfilenameEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	WaitonlockEnum,
	NumberOfVariablesEnum,
	NumvariabledescriptorsEnum,
	NumberOfResponsesEnum,
	NumresponsedescriptorsEnum,
	NpartEnum,
	QmuMassFluxNumProfilesEnum
};

/*Functions on enums: */
char *EnumToModelField(int  en);

#endif
