%PLANET class definition
%
%   Usage:
%      md = planet(varargin)

classdef planet < model
    properties (SetAccess=public) %Planet fields
		 % {{{1
		 %Planet specific fields
		 r=NaN;
		 theta=NaN;
		 phi=NaN;
		 %}}}
	 end
	 methods
		function md=planetmesh(md,varargin) % {{{1
		%PLANETMESH: build 2d shell mesh
		%
		% Usage: md=planetmesh(md,'method','mixed','radius',6378000,'angleresol',1);
		%        md=planetmesh(md,'method','tria','shape','iso','radius',6378000,'refinement',5);
		%

		%recover options
		options=pairoptions(varargin{:});

		method=getfieldvalue(options,'method','mixed');
		
		if strcmpi(method,'mixed'),
			%recover radius and angleresol: 
			radius=getfieldvalue(options,'radius',6378000); %earth radius as default
			angleresol=getfieldvalue(options,'angleresol',10); %10 degree resolution
			
			%call mixed mesh 
			md=planetmixedmesh(md,radius,angleresol);
		else
			%recover radius, shape and level of refinmenet
			radius=getfieldvalue(options,'radius',6378000); %earth radius as default
			refinement=getfieldvalue(options,'refinement',5); %refine 5 times
			shape=getfieldvalue(options,'shape','ico'); 
			
			%call triangular mesh
			md=planettrimesh(md,shape,radius,refinement);
		end

		end
		% }}}
	 end
 end
