/*!\file:  adjointdiagnostic_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
#include "../solvers/solvers.h"

void adjointdiagnostic_core(FemModel* femmodel){
	
	/*parameters: */
	bool isstokes;
	bool control_analysis;
	bool conserve_loads   = true;
	int  solution_type;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&isstokes,IsstokesEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*Compute velocities*/
	_printf_(VerboseSolution(),"%s\n","   computing velocities");
	femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
	solver_nonlinear(femmodel,conserve_loads); 

	/*Call SurfaceAreax, because some it might be needed by PVector*/
	SurfaceAreax(NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	/*Compute adjoint*/
	_printf_(VerboseSolution(),"%s\n","   computing adjoint");
	femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	solver_adjoint_linear(femmodel);
	
	/*Save results*/
	if(solution_type==AdjointSolutionEnum && !control_analysis){
		_printf_(VerboseSolution(),"   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointyEnum);
		if (isstokes){
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointzEnum);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointpEnum);
		}
	}
}
