/*
 * CreateNodesPrognostic.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../io/io.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesPrognostic(Nodes** pnodes, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int  i,j;
	int  node_id;
	int  vertex_id;
	int  io_index;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Create partition of nodes: */
	if(iomodel->prognostic_DG) continuous_galerkin=false;
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,iomodel_handle,continuous_galerkin);

	/*Check in 3d*/
	if(iomodel->prognostic_DG && iomodel->dim==3) _error_("DG 3d not implemented yet");

	/*First fetch data: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);
	IoModelFetchData(&iomodel->nodeonbed,NULL,NULL,iomodel_handle,NodeOnBedEnum);
	IoModelFetchData(&iomodel->nodeonsurface,NULL,NULL,iomodel_handle,NodeOnSurfaceEnum);
	IoModelFetchData(&iomodel->nodeonicesheet,NULL,NULL,iomodel_handle,NodeOnIceSheetEnum);
	IoModelFetchData(&iomodel->nodeoniceshelf,NULL,NULL,iomodel_handle,NodeOnIceShelfEnum);
	IoModelFetchData(&iomodel->vertices_type,NULL,NULL,iomodel_handle,VerticesTypeEnum);
	IoModelFetchData(&iomodel->nodeonwater,NULL,NULL,iomodel_handle,NodeOnWaterEnum);

	if(continuous_galerkin){

		/*Build Nodes dataset (Continuous Galerkin)*/
		for (i=0;i<iomodel->numberofvertices;i++){

			if(iomodel->my_vertices[i]){

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,PrognosticAnalysisEnum));

			}
		}
	}
	else{

		/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
		for (i=0;i<iomodel->numberofelements;i++){
			for (j=0;j<3;j++){

				if(iomodel->my_nodes[3*i+j]){ 

					//Get index of the vertex on which the current node is located
					vertex_id=(int)*(iomodel->elements+3*i+j); //(Matlab indexing)
					io_index=vertex_id-1;                      //(C indexing)
					_assert_(vertex_id>0 && vertex_id<=iomodel->numberofvertices);

					//Compute Node id
					node_id=iomodel->nodecounter+3*i+j+1;

					/*Add node to nodes dataset: */
					nodes->AddObject(new Node(node_id,node_id-1,vertex_id,io_index,iomodel,PrognosticAnalysisEnum));

				}
			}
		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->nodeoniceshelf);
	xfree((void**)&iomodel->nodeonwater);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->vertices_type);	

	/*Assign output pointer: */
	*pnodes=nodes;
}
