/*
 * CreateConstraintsHydrology.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../io/io.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsHydrology(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int count;
	
	/*Output*/
	Constraints *constraints = NULL;
	Spc         *spc         = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcwatercolumn,NULL,NULL,iomodel_handle,SpcwatercolumnEnum);

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
	
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){

			if ((int)iomodel->spcwatercolumn[2*i]){

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcwatercolumn+2*i+1),HydrologyAnalysisEnum));
				count++;
			}
		} //if((my_vertices[i]))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcwatercolumn);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
