/*! \file CreateLoadsBalancethickness.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsBalancethickness(Loads** ploads, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int element;

	/*Output*/
	Loads*    loads    = NULL;

	/*Recover pointer: */
	loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads(LoadsEnum);
	
	/*Loads only in DG*/
	if (iomodel->prognostic_DG){

		/*Get edges and elements*/
		IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,EdgesEnum);
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,ThicknessEnum);

		/*First load data:*/
		for (i=0;i<iomodel->numberofedges;i++){

			/*Get left and right elements*/
			element=(int)iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]

			/*Now, if this element is not in the partition, pass: */
			if(!iomodel->my_elements[element]) continue;

			/* Add load */
			loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,iomodel,BalancethicknessAnalysisEnum));
		}

		/*Free data: */
		xfree((void**)&iomodel->edges);
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->thickness);
	}

	/*Assign output pointer: */
	*ploads=loads;
}
