/*!\file: hydrology_core.cpp
 * \brief: core of the hydrology solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void hydrology_core(FemModel* femmodel){

	int i;

	/*intermediary*/
	double time;
	int    nsteps;
	double ndt;
	double dt;
	bool control_analysis;
	int solution_type;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&ndt,NdtEnum);
	femmodel->parameters->FindParam(&dt,DtEnum);
	femmodel->parameters->FindParam(&control_analysis,ControlAnalysisEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	/*first compute slopes: */
	surfaceslope_core(femmodel);
	bedslope_core(femmodel);

	/*Compute number of time steps: */
	if((dt==0)|| (ndt==0)){
		dt=0;
		nsteps=1;
	}
	else nsteps=(int)(ndt/dt);

	/*Loop through time: */
	for(i=0;i<nsteps;i++){
		
		if(nsteps)_printf_(VerboseSolution(),"time step:%i/%i\n",i+1,nsteps);
		time=(i+1)*dt;

		/*call hydrology_core step: */
		hydrology_core_step(femmodel,i,time);

		if(solution_type==HydrologySolutionEnum && !control_analysis){
			_printf_(VerboseSolution(),"   saving results\n");
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,WatercolumnEnum,i+1,time);
		}

	}
}

