/*
 * UpdateElementsSurfaceSlope:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsSurfaceSlope(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,SurfaceEnum);
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,BedEnum);
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,ElementOnWaterEnum);

	if (iomodel->dim==3){
		IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,ElementOnBedEnum);
		IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,ElementOnSurfaceEnum);
	}

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
}
