/*
 * UpdateElementsMelting:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	UpdateElementsMelting(Elements* elements, IoModel* iomodel,FILE* iomodel_handle,int analysis_counter,int analysis_type){

	/*Intermediary*/
	int i;
	int counter;
	Element* element=NULL;

	/*Now, is the model 3d? otherwise, do nothing: */
	if (iomodel->dim==2)goto cleanup_and_return;

	/*Fetch data needed: */
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,ElementsEnum);
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,ThicknessEnum);
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,SurfaceEnum);
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,BedEnum);
	IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,DragCoefficientEnum);
	IoModelFetchData(&iomodel->drag_p,NULL,NULL,iomodel_handle,DragPEnum);
	IoModelFetchData(&iomodel->drag_q,NULL,NULL,iomodel_handle,DragQEnum);
	IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,ElementOnIceShelfEnum);
	IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,ElementOnBedEnum);
	IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,ElementOnSurfaceEnum);
	IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,ElementOnWaterEnum);
	IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,ElementsTypeEnum);
	IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,RheologyBEnum);
	IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,RheologyNEnum);
   IoModelFetchData(&iomodel->surface_accumulation_rate,NULL,NULL,iomodel_handle,SurfaceAccumulationRateEnum);
	IoModelFetchData(&iomodel->surface_ablation_rate,NULL,NULL,iomodel_handle,SurfaceAblationRateEnum);
	IoModelFetchData(&iomodel->surface_mass_balance,NULL,NULL,iomodel_handle,SurfaceMassBalanceEnum);
	IoModelFetchData(&iomodel->basal_melting_rate,NULL,NULL,iomodel_handle,BasalMeltingRateEnum);
	IoModelFetchData(&iomodel->pressure,NULL,NULL,iomodel_handle,PressureEnum);

	/*Update elements: */
	counter=0;
	for (i=0;i<iomodel->numberofelements;i++){
		if(iomodel->my_elements[i]){
			element=(Element*)elements->GetObjectByOffset(counter);
			element->Update(i,iomodel,analysis_counter,analysis_type); //we need i to index into elements.
			counter++;
		}
	}

	cleanup_and_return:
	/*Free data: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->drag_coefficient);
	xfree((void**)&iomodel->drag_p);
	xfree((void**)&iomodel->drag_q);
	xfree((void**)&iomodel->elementoniceshelf);
	xfree((void**)&iomodel->elementonbed);
	xfree((void**)&iomodel->elementonsurface);
	xfree((void**)&iomodel->elementonwater);
	xfree((void**)&iomodel->elements_type);
	xfree((void**)&iomodel->rheology_B);
	xfree((void**)&iomodel->rheology_n);
	xfree((void**)&iomodel->basal_melting_rate);
   xfree((void**)&iomodel->surface_accumulation_rate);
	xfree((void**)&iomodel->surface_ablation_rate);
	xfree((void**)&iomodel->surface_mass_balance);
	xfree((void**)&iomodel->pressure);
}
