/*
 * CreateNodesDiagnosticVert.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticVert(Nodes** pnodes, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	bool continuous_galerkin=true;

	/*DataSets: */
	Nodes*    nodes = NULL;

	/*Recover pointer: */
	nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes(NodesEnum);

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (iomodel->dim==2)goto cleanup_and_return;

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,iomodel_handle,continuous_galerkin);
	
	/*First fetch data: */
	IoModelFetchData(&iomodel->nodeonbed,NULL,NULL,iomodel_handle,NodeOnBedEnum);
	IoModelFetchData(&iomodel->nodeonsurface,NULL,NULL,iomodel_handle,NodeOnSurfaceEnum);
	IoModelFetchData(&iomodel->nodeonicesheet,NULL,NULL,iomodel_handle,NodeOnIceSheetEnum);
	IoModelFetchData(&iomodel->nodeoniceshelf,NULL,NULL,iomodel_handle,NodeOnIceShelfEnum);
	IoModelFetchData(&iomodel->vertices_type,NULL,NULL,iomodel_handle,VerticesTypeEnum);
	IoModelFetchData(&iomodel->nodeonwater,NULL,NULL,iomodel_handle,NodeOnWaterEnum);

	for (i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticVertAnalysisEnum));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->nodeonbed);
	xfree((void**)&iomodel->nodeonsurface);
	xfree((void**)&iomodel->nodeonicesheet);
	xfree((void**)&iomodel->nodeoniceshelf);
	xfree((void**)&iomodel->nodeonwater);
	xfree((void**)&iomodel->vertices_type);	
	
	cleanup_and_return:

	/*Assign output pointer: */
	*pnodes=nodes;
}
