/*!\file: CreateParameters.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../Container/Container.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../MeshPartitionx/MeshPartitionx.h"
#include "../../io/io.h"
#include "./ModelProcessorx.h"

void CreateParameters(Parameters** pparameters,IoModel* iomodel,FILE* iomodel_handle,const int solution_type,int analysis_type,int analysis_counter){
	
	int i;
	
	Parameters* parameters = NULL;

	char**   parameteroutput=NULL;
	int      numparameters=0;
	
	if(*pparameters)return; //do not create parameters twice!
		
	/*Initialize dataset: */
	parameters = new Parameters(ParametersEnum);

	parameters->AddObject(new IntParam(SolutionTypeEnum,solution_type));
	parameters->AddObject(new IntParam(AnalysisTypeEnum,analysis_type));
	parameters->AddObject(new IntParam(AnalysisCounterEnum,analysis_counter));

	parameters->AddObject(new IntParam(DimEnum,iomodel->dim));
	parameters->AddObject(new BoolParam(IshutterEnum,iomodel->ishutter));
	parameters->AddObject(new BoolParam(IsmacayealpattynEnum,iomodel->ismacayealpattyn));
	parameters->AddObject(new BoolParam(IsstokesEnum,iomodel->isstokes));
	parameters->AddObject(new IntParam(OutputFrequencyEnum,iomodel->output_frequency));
	parameters->AddObject(new DoubleParam(EpsResEnum,iomodel->eps_res));
	parameters->AddObject(new DoubleParam(EpsRelEnum,iomodel->eps_rel));
	parameters->AddObject(new DoubleParam(EpsAbsEnum,iomodel->eps_abs));
	parameters->AddObject(new IntParam(MaxNonlinearIterationsEnum,(IssmInt)iomodel->max_nonlinear_iterations));
	parameters->AddObject(new DoubleParam(EpsvelEnum,iomodel->epsvel));
	parameters->AddObject(new DoubleParam(YtsEnum,iomodel->yts));
	parameters->AddObject(new DoubleParam(DtEnum,iomodel->dt*iomodel->yts));  //Ndt is in yeats in iomodel
	parameters->AddObject(new DoubleParam(NdtEnum,iomodel->ndt*iomodel->yts));//Ndt is in yeats in iomodel
	parameters->AddObject(new BoolParam(TimeAdaptEnum,iomodel->time_adapt)); 
	parameters->AddObject(new DoubleParam(CflCoefficientEnum,iomodel->cfl_coefficient)); 
	parameters->AddObject(new IntParam(HydrostaticAdjustmentEnum,iomodel->hydrostatic_adjustment)); 
	parameters->AddObject(new DoubleParam(PenaltyOffsetEnum,iomodel->penalty_offset));
	parameters->AddObject(new DoubleParam(SparsityEnum,iomodel->sparsity));
	parameters->AddObject(new BoolParam(LowmemEnum,iomodel->lowmem));
	parameters->AddObject(new IntParam(ConnectivityEnum,iomodel->connectivity));
	parameters->AddObject(new DoubleParam(BetaEnum,iomodel->beta));
	parameters->AddObject(new DoubleParam(MeltingpointEnum,iomodel->meltingpoint));
	parameters->AddObject(new DoubleParam(ReferencetemperatureEnum,iomodel->referencetemperature));
	parameters->AddObject(new DoubleParam(LatentheatEnum,iomodel->latentheat));
	parameters->AddObject(new DoubleParam(HeatcapacityEnum,iomodel->heatcapacity));
	parameters->AddObject(new IntParam(ArtDiffEnum,iomodel->artdiff));
	parameters->AddObject(new IntParam(BasalMeltingRateCorrectionApplyEnum,iomodel->basal_melting_rate_correction_apply));
	parameters->AddObject(new DoubleParam(GroundingLineMeltingRateEnum,iomodel->gl_melting_rate));
	parameters->AddObject(new DoubleParam(PenaltyMeltingEnum,iomodel->penalty_melting));
	parameters->AddObject(new IntParam(MinThermalConstraintsEnum,iomodel->min_thermal_constraints));
	parameters->AddObject(new IntParam(MinMechanicalConstraintsEnum,iomodel->min_mechanical_constraints));
	parameters->AddObject(new IntParam(StabilizeConstraintsEnum,iomodel->stabilize_constraints));
	parameters->AddObject(new DoubleParam(StokesreconditioningEnum,iomodel->stokesreconditioning));
	parameters->AddObject(new IntParam(ShelfDampeningEnum,iomodel->shelf_dampening));
	parameters->AddObject(new DoubleParam(ViscosityOvershootEnum,iomodel->viscosity_overshoot));
	parameters->AddObject(new BoolParam(WaitonlockEnum,iomodel->waitonlock));
	parameters->AddObject(new IntParam(NumberOfElementsEnum,iomodel->numberofelements));
	parameters->AddObject(new BoolParam(IoGatherEnum,iomodel->io_gather));
	parameters->AddObject(new IntParam(GroundingLineMigrationEnum,iomodel->gl_migration));
	parameters->AddObject(new IntParam(RheologyLawEnum,iomodel->rheology_law));
	parameters->AddObject(new BoolParam(IsdiagnosticEnum,iomodel->isdiagnostic));
	parameters->AddObject(new BoolParam(IsprognosticEnum,iomodel->isprognostic));
	parameters->AddObject(new BoolParam(IsthermalEnum,iomodel->isthermal));

	/*Deal with more complex parameters*/
	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,RiftinfoEnum);
	parameters->AddObject(new IntParam(NumRiftsEnum,iomodel->numrifts));
	xfree((void**)&iomodel->riftinfo); 

	
	/*Deal with parametr outputs: */
	IoModelFetchData(&parameteroutput,&numparameters,iomodel_handle,ParameteroutputEnum);
	if(numparameters) parameters->AddObject(new StringArrayParam(ParameteroutputEnum,parameteroutput,numparameters));

	/*Before returning, create parameters in case we are running Qmu or control types runs: */
	CreateParametersControl(&parameters,iomodel,iomodel_handle,solution_type,analysis_type);
	CreateParametersQmu(&parameters,iomodel,iomodel_handle,solution_type,analysis_type);

	/*Assign output pointer: */
	*pparameters=parameters;
}
