/*\file diskio.h
 *\brief: I/O for ISSM from disk
 */

#ifndef _DISK_IO_H_
#define _DISK_IO_H_

#include "../../objects/objects.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

class DataSet;
class Parameters;

FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

void  IoModelFetchData(double** pmatrix,int* pM,int* pN,FILE* model_handle,char* data_name);
void  IoModelFetchData(char** pstring,FILE* model_handle,char* data_name);
void  IoModelFetchData(double* pscalar,FILE* model_handle,char* data_name);
void  IoModelFetchData(int* pinteger,FILE* model_handle,char* data_name);
FILE* SetFilePointerToData(FILE* model_handle,char* data_name);

#endif	/* _IO_H_ */
