/*\file Reduceload.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceload.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec         pf         = NULL;
	Mat         Kfs        = NULL;
	Vec         ys         = NULL;
	bool        flag_ys0=false;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=3 && nrhs!=4)){
		ReduceloadUsage();
		_error_(" usage. See above");
	}

	/*Input datasets: */
	FetchMatlabData(&pf,PF);
	FetchMatlabData(&Kfs,KFS);
	FetchMatlabData(&ys,YS);

	/*!Reduce load from g to f size: */
	if(nrhs==4){
		FetchMatlabData(&flag_ys0,YSFLAG);
		Reduceloadx(pf, Kfs, ys,flag_ys0);
	}
	else{
		Reduceloadx(pf, Kfs, ys);
	}

	/*write output datasets: */
	WriteMatlabData(PFOUT,pf);

	/*Free ressources: */
	VecFree(&pf);
	MatFree(&Kfs);
	VecFree(&ys);

	MODULEEND();
}

void ReduceloadUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [pf] = %s(pf,Kfs,ys);\n",__FUNCT__);
	_printf_(true,"          [pf] = %s(pf,Kfs,ys,ys0_flag);\n",__FUNCT__);
	_printf_(true,"\n");
}
