/*\file PropagateFlagsFromConnectivity.c
 *\brief: propagate flags onto mesh, element by element, using connectivity.
 */

#include "./PropagateFlagsFromConnectivity.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input/output datasets: */
	double* connectivity=NULL;
	int     nel;
	double* pool=NULL;
	double* flags=NULL;
	int     index;
	int     dummy;
	
	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PropagateFlagsFromConnectivityUsage);
        
	/*Input datasets: */
	FetchMatlabData(&connectivity,&nel,&dummy,CONNECTIVITY);
	FetchMatlabData(&pool,&dummy,POOL);
	FetchMatlabData(&index,INDEX);
	FetchMatlabData(&flags,&dummy,FLAGS);

	/*!Generate internal degree of freedom numbers: */
	PropagateFlagsFromConnectivityx(pool,connectivity,index,flags);

	/*write output datasets: */
	WriteMatlabData(POOLOUT,pool,nel);

	/*Free ressources: */
	xfree((void**)&connectivity);
	xfree((void**)&flags);

	/*end module: */
	MODULEEND();
}

void PropagateFlagsFromConnectivityUsage(void) {
	printf("\n");
	printf("   usage: [pool] = %s(connectivity,pool,index,flags);\n",__FUNCT__);
	printf("\n");
}
