/*\file KMLFileRead.c
 *\brief: KML file reader module.
 */
#include "./KMLFileRead.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i,j,nnodes=0,verbose=1;
	KML_Object* kobj;

	/*input: */
	char*   name=NULL;

	char*   notes=NULL;
	const mxArray* notesi;
	mwIndex        nindex;

	int*    elem=NULL;
	int     melem=0,nelem=0;

	int*    nodecon=NULL;
	int     mncon=0,nncon=0;

	double* lat=NULL;
	int     mlat=0,nlat=0,llat=0;

	double* lng=NULL;
	int     mlng=0,nlng=0,llng=0;

	int     nparts=0;

	int*    part=NULL;
	int     mprt=0,nprt=0,lprt=0;

	double* data=NULL;
	int     mdata=0,ndata=0;

	double* cmap=NULL;
	int     mcmap=0,ncmap=0;

	char*   filnam=NULL;

	FILE*   fidi=NULL;
	FILE*   fido=NULL;

	Options* options=NULL;
	char*    echo    =NULL;
	char*    deepecho=NULL;
	char*    write   =NULL;

	/* output: */
	int     ierror=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if (nlhs > NLHS) {
		KMLFileReadUsage();
		_error_("KMLFileRead usage error");
	}
	if (nrhs < NRHS) {
		KMLFileReadUsage();
		_error_("KMLFileRead usage error");
	}

	/*Input datasets: */
	if (verbose) printf("Fetching inputs:\n");
	FetchMatlabData(&filnam,FILENAME);
	if (verbose) printf("  filnam =\"%s\"\n",filnam);

	if (verbose) printf("Parsing options:\n");
	options=new Options(NRHS,nrhs,prhs);
	if (options->Size()) for(i=0;i<options->Size();i++) ((Option*)options->GetObjectByOffset(i))->DeepEcho();
	options->Get(&echo    ,"echo"    ,"no");
	options->Get(&deepecho,"deepecho","no");
	options->Get(&write   ,"write"   ,"no");

	/*some checks*/
	if (verbose) printf("Checking inputs:\n");

	if (!strlen(filnam))
		strcpy(filnam,"stdout");

	if (verbose) printf("Opening file \"%s\".\n",filnam);
	fidi=fopen(filnam,"r");

	/* Run core computations: */
	if (verbose) printf("Calling core:\n");
	kobj=KMLFileReadx(fidi);

	if (verbose) printf("Closing file \"%s\".\n",filnam);
	fclose(fidi);

	if (kobj) {
		if (!strncmp(echo    ,"y",1) || !strncmp(echo    ,"on",2))
			kobj->Echo();
		if (!strncmp(deepecho,"y",1) || !strncmp(deepecho,"on",2))
			kobj->DeepEcho();
		if (strncmp(write,"no",2) && strncmp(write,"off",3)) {
			if (verbose) printf("Opening file \"%s\".\n",write);
			fido=fopen(write,"w");

			kobj->Write(fido,"");

			if (verbose) printf("Closing file \"%s\".\n",write);
			fclose(fido);
		}

		delete kobj;
	}

	/*Write data: */
	WriteMatlabData(ERRORFLAG,ierror);

	/*Clean-up*/
	xfree((void**)&write);
	xfree((void**)&deepecho);
	xfree((void**)&echo);
	delete options;

	/*end module: */
	MODULEEND();
}

void KMLFileReadUsage(void)
{
	_printf_(true,"KMLFileRead - KML file reader module:\n");
	_printf_(true,"\n");
	_printf_(true,"   This module reads a KML file.\n");
	_printf_(true,"\n");
	_printf_(true,"   Usage:\n");
	_printf_(true,"      ierror=KMLMeshWrite(name,notes,elem,nodecon,lat,long,part,data,cmap,kmlfile);\n");
	_printf_(true,"\n");
	_printf_(true,"      name       model name (string, may be empty)\n");
	_printf_(true,"      notes      model notes (string or cell array of strings, may be empty)\n");
	_printf_(true,"      elem       elements (double array)\n");
	_printf_(true,"      nodecon    nodal connectivity array (double array, may be empty)\n");
	_printf_(true,"      lat        nodal latititudes (double vector)\n");
	_printf_(true,"      long       nodal longitudes (double vector)\n");
	_printf_(true,"      part       nodal partitions (double vector, may be empty)\n");
	_printf_(true,"      data       nodal or element data (double vector, may be empty)\n");
	_printf_(true,"      cmap       color map (double nx3 array, may be empty)\n");
	_printf_(true,"      kmlfile    KML file name (string)\n");
	_printf_(true,"\n");
	_printf_(true,"      ierror     error flag (double, non-zero for error)\n");
	_printf_(true,"\n");
	_printf_(true,"   Example:\n");
	_printf_(true,"      KMLMeshWrite(md.name,md.notes,md.elements,md.nodeconnectivity,md.lat,md.long,md.part,md.fm_criterion,options.cmap,filekml);\n");
	_printf_(true,"\n");
}

