/*\file InterpFromMeshToGrid.c
 *\brief: compute diff between observed and modeled velocity
 */

#include "./InterpFromMeshToGrid.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	double* index=NULL;
	int     nel;
	double* x=NULL;
	int     nods;
	double* y=NULL;
	double* meshdata=NULL;
	int     meshdata_length;
	double  cornereast;
	double  cornernorth;
	double  xposting;
	double  yposting;
	int     nlines,ncols;
	double  default_value;

	/* output datasets: */
	double* griddata=NULL;
	double* x_m=NULL;
	double* y_m=NULL;


	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromMeshToGridUsage);

	/*Input datasets: */
	FetchMatlabData(&index,&nel,NULL,INDEX);
	FetchMatlabData(&x,&nods,NULL,X);
	FetchMatlabData(&y,NULL,NULL,Y);
	FetchMatlabData(&meshdata,&meshdata_length,NULL,MESHDATA);
	FetchMatlabData(&cornereast,CORNEREAST);
	FetchMatlabData(&cornernorth,CORNERNORTH);
	FetchMatlabData(&xposting,XPOSTING);
	FetchMatlabData(&yposting,YPOSTING);
	FetchMatlabData(&nlines,NLINES);
	FetchMatlabData(&ncols,NCOLS);
	FetchMatlabData(&default_value,DEFAULTVALUE);

	/*Call core of computation: */
	InterpFromMeshToGridx(&x_m,&y_m,&griddata,index,x,y,nods,nel,meshdata,meshdata_length,cornereast,cornernorth,xposting,yposting,nlines,ncols,default_value);

	/*Write results: */
	WriteMatlabData(XM,x_m,ncols+1);
	WriteMatlabData(YM,y_m,nlines+1);
	WriteMatlabData(GRIDDATA,griddata,nlines,ncols);

	/*Free ressources: */
	//let matlab do this.
	
	/*end module: */
	MODULEEND();
}

void InterpFromMeshToGridUsage(void)
{
	_printf_(true,"INTERPFROMMESHTOGRID - interpolation of a data defined on a mesh onto a grid\n");
	_printf_(true,"\n");
	_printf_(true,"   This function is a multi-threaded mex file that interpolates a field\n");
	_printf_(true,"   defined on a triangular mesh onto a regular grid\n");
	_printf_(true,"\n");
	_printf_(true,"   Usage:\n");
	_printf_(true,"      [x_m,y_m,griddata]=InterpFromMeshToGrid(index,x,y,data,cornereast,cornernorth,xposting,yposting,nlines,ncols,default_value)\n");
	_printf_(true,"\n");
	_printf_(true,"      index,x,y: delaunay triangulation defining the mesh.\n");
	_printf_(true,"      meshdata: vertex values of data to be interpolated.\n");
	_printf_(true,"      cornereast,cornernorth,posting,nlines,ncols: parameters that define the grid\n");
	_printf_(true,"      default_value: value of points located out of the mesh.\n");
	_printf_(true,"\n");
}
