/*\file ProcessParams.c
 *\brief: configure objects (elements, loads for example), that need linking with nodes
 */

#include "./ProcessParams.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Parameters* parameters=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ProcessParamsUsage);
	
	/*Input datasets: */
	FetchMatlabData((DataSet**)&parameters,PARAMETERS);

	/*write output datasets: */
	WriteMatlabData(PARAMETERSOUT,parameters);

	/*Free ressources: */
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ProcessParamsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [parameters] = %s(parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
