/*\file ParsePetscOptions.c
 *\brief: add petsc options to parameters
 */

#include "./ParsePetscOptions.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Parameters *parameters = NULL;
	char*       petscoptionsfilename=NULL;
	FILE*       petscoptionsfid=NULL;
	
	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ParsePetscOptionsUsage);

	/*Input datasets: */
	FetchMatlabData(&parameters,PARAMETERS);
	FetchMatlabData(&petscoptionsfilename,PETSCOPTIONSFILENAME); 

	petscoptionsfid=fopen(petscoptionsfilename,"r");
	if(petscoptionsfid==NULL)_error_("could not open petsc solver options  file for reading\n");

	ParsePetscOptionsx(parameters,petscoptionsfid);

	/*write output datasets: */
	WriteMatlabData(PARAMETERSOUT,parameters);
	
	/*Free ressources: */
	delete parameters;
	xfree((void**)&petscoptionsfilename);
	fclose(petscoptionsfid);

	/*end module: */
	MODULEEND();
}

void ParsePetscOptionsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [parameters] = %s(parameters,petscoptionsfilename);\n",__FUNCT__);
	_printf_(true,"\n");
}
