/*\file InputScale.c
 *\brief: duplicate input
 */

#include "./InputScale.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;
	int      enum_type;
	double   scale_factor;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputScaleUsage);

	/*Input datasets: */
	FetchMatlabData((DataSet**)&elements,ELEMENTS);
	FetchMatlabData((DataSet**)&nodes,NODES);
	FetchMatlabData((DataSet**)&vertices,VERTICES);
	FetchMatlabData((DataSet**)&loads,LOADS);
	FetchMatlabData((DataSet**)&materials,MATERIALS);
	FetchMatlabData(&parameters,PARAMETERS);
	
	FetchMatlabData(&enum_type,ENUMTYPE);
	FetchMatlabData(&scale_factor,SCALEFACTOR);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	InputScalex( elements, nodes, vertices, loads, materials,parameters,enum_type, scale_factor);

	/*write output : */
	WriteMatlabData(ELEMENTSOUT,elements);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	/*end module: */
	MODULEEND();

}

void InputScaleUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: [elements] = %s(elements, nodes, vertices, loads, materials, parameters, enum_type,scale_factor);\n",__FUNCT__);
	_printf_(true,"\n");
}
