/*\file io.h
 *\brief: I/O for ISSM
 */

#ifndef _IO_H_
#define _IO_H_

#include "../objects/objects.h"
#include "../Container/Container.h"
#include "../include/include.h"

class DataSet;
class Parameters;

FILE* pfopen(char* filename,char* format);
void  pfclose(FILE* fid,char* filename);

void  FetchData(double** pmatrix, int* pM,int* pN,FILE* fid);
void  FetchData(char** pstring,FILE* fid);
void  FetchData(double* pscalar,FILE* fid);
void  FetchData(int* pinteger,FILE* fid);

void  IoModelFetchData(double** pmatrix,int* pM,int* pN,FILE* model_handle,char* data_name);
void  IoModelFetchData(char** pstring,FILE* model_handle,char* data_name);
void  IoModelFetchData(double* pscalar,FILE* model_handle,char* data_name);
void  IoModelFetchData(int* pinteger,FILE* model_handle,char* data_name);
FILE* SetFilePointerToData(FILE* model_handle,char* data_name);

#ifdef _SERIAL_
void WriteData(mxArray** pdataref,DataSet* dataset);
void WriteData(mxArray** pdataref,Mat matrix);
void WriteData(mxArray** pdataref,double* matrix, int M,int N);
void WriteData(mxArray** pdataref,Vec vector);
void WriteData(mxArray** pdataref,double* vector, int M);
void WriteData(mxArray** pdataref,int integer);
void WriteData(mxArray** pdataref,bool boolean);
void WriteData(mxArray** pdataref,double scalar);
void WriteData(mxArray** pdataref,char* string);
void WriteNodeSets(DataHandle* pdataref,NodeSets* nodesets);
void WriteParams(DataHandle* pdataref,Parameters* parameters);

void FetchData(DataSet** pdataset,const mxArray* dataref);
void FetchData(double** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(double** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(int** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(bool** pmatrix,int* pM,int *pN,const mxArray* dataref);
void FetchData(bool** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(Mat* pmatrix,const mxArray* dataref);
void FetchData(int** pvector,int* pM,const mxArray* dataref);
void FetchData(float** pvector,int* pM,const mxArray* dataref);
void FetchData(double** pvector,int* pM,const mxArray* dataref);
void FetchData(bool** pvector,int* pM,const mxArray* dataref);
void FetchData(Vec* pvector,const mxArray* dataref);
void FetchData(char** pstring,const mxArray* dataref);
void FetchData(char** pmatrix,int* pnumel,int* pndims,int** psize,const mxArray* dataref);
void FetchData(double* pscalar,const mxArray* dataref);
void FetchData(int* pinteger,const mxArray* dataref);
void FetchData(bool* pbool,const mxArray* dataref);
void FetchNodeSets(NodeSets** pnodesets,ConstDataHandle dataref);
void FetchParams(Parameters** pparameters, DataHandle dataref);

Option* OptionParse(char* name, const mxArray* prhs[]);
OptionDouble*   OptionDoubleParse( char* name, const mxArray* prhs[]);
OptionLogical*  OptionLogicalParse( char* name, const mxArray* prhs[]);
OptionChar*     OptionCharParse( char* name, const mxArray* prhs[]);
OptionStruct*   OptionStructParse( char* name, const mxArray* prhs[]);
OptionCell*     OptionCellParse( char* name, const mxArray* prhs[]);
#endif
#endif	/* _IO_H_ */
