/*! \file IoModelFetchData.c
 *  \brief: wrapper to the I/O routines, for special processing of the IoModel structure.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./io.h"

/*FUNCTION IoModelFetchData(double** pmatrix,int* pM,int* pN,FILE* model_handle,char* data_name){{{1*/
void  IoModelFetchData(double** pmatrix,int* pM,int* pN,FILE* model_handle,char* data_name){
	
	FILE* fid=NULL;
	
	/*Set file pointer to beginning of the data: */
	fid=SetFilePointerToData(model_handle,data_name);
	
	/*Now fetch: */
	FetchData(pmatrix,pM,pN,fid);

}
/*}}}*/
/*FUNCTION IoModelFetchData(char** pstring,FILE* model_handle,char* data_name){{{1*/
void  IoModelFetchData(char** pstring,FILE* model_handle,char* data_name){

	FILE* fid=NULL;
	
	/*Set file pointer to beginning of the data: */
	fid=SetFilePointerToData(model_handle,data_name);
	
	/*Now fetch: */
	FetchData(pstring,fid);
}
/*}}}*/
/*FUNCTION IoModelFetchData(double* pscalar,FILE* model_handle,char* data_name){{{1*/
void  IoModelFetchData(double* pscalar,FILE* model_handle,char* data_name){

	FILE* fid=NULL;
	
	/*Set file pointer to beginning of the data: */
	fid=SetFilePointerToData(model_handle,data_name);
	
	/*Now fetch: */
	FetchData(pscalar,fid);
}
/*}}}*/
/*FUNCTION IoModelFetchData(int* pinteger,FILE* model_handle,char* data_name){{{1*/
void  IoModelFetchData(int* pinteger,FILE* model_handle,char* data_name){

	FILE* fid=NULL;
	
	/*Set file pointer to beginning of the data: */
	fid=SetFilePointerToData(model_handle,data_name);
	
	/*Now fetch: */
	FetchData(pinteger,fid);
}
/*}}}*/
/*FUNCTION SetFilePointerToData(FILE* model_handle,char* data_name){{{1*/
FILE* SetFilePointerToData(FILE* model_handle,char* data_name){

	extern int my_rank;
	extern int num_procs;
	
	int string_size;
	int record_length;
	char* string=NULL;
	char* repository=NULL;
	FILE* fid=NULL;
	int found=0;

	/*Go find in the binary file, the position of the data we want to fetch: */
	if(my_rank==0){
	
		/*First set FILE* position to the beginning of the file: */
		fid=(FILE*)model_handle;
		fseek(fid,0,SEEK_SET);

		/*Now march through file looking for the correct name: */
		for(;;){
			/*Read size of first string name: */
			if(fread(&string_size,sizeof(int),1,fid)==0){
				/*Ok, we have reached the end of the file. break: */
				found=0;
				break;
			}
			/*Allocate string of correct size: */
			string=(char*)xmalloc((string_size+1)*sizeof(char));
			string[string_size]='\0';

			/*Read string: */
			if(fread(string,string_size*sizeof(char),1,fid)==0){
				/*Ok, we have reached the end of the file. break: */
				found=0;
				break;
			}
			/*Is this the correct string? : */
			if (strcmp(string,data_name)==0){
				/*Ok, we have found the correct string. Pass the record length, and break: */
				fseek(fid,sizeof(int),SEEK_CUR);
				found=1;
				break;
			}
			else{
				/*This is not the correct string, read the record length, and skip it: */
				fread(&record_length,sizeof(int),1,fid);
				/*skip: */
				fseek(fid,record_length,SEEK_CUR);
			}
			/*Erase string: */
			xfree((void**)&string);
		}
		/*erase string, if we broke from the for() loop:*/
		xfree((void**)&string);
	}
	MPI_Bcast(&found,1,MPI_INT,0,MPI_COMM_WORLD); 

	if(!found)_error_("%s %s ","could not find data with name",data_name);

	return fid;
}
/*}}}*/
