md=mesh(model,'../Exp/Square.exp',350000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster=generic('name',oshostname(),'np',3);
md.isthermal=0;

md.dt=1;
md.output_frequency=1;
md.ndt=2000;

%Solve for thinning rate -> -1 * surface mass balance
smb= 2*ones(md.numberofnodes,1);   
md.surface_mass_balance= smb;
md.basal_melting_rate= smb;

md=solve(md,PrognosticSolutionEnum);

for i=1:10
	 md=solve(md,PrognosticSolutionEnum);
	 md.surface_mass_balance= md.surface_mass_balance - (PatchToVec(md.results.PrognosticSolution.Thickness)-md.thickness);
end

%Set up transient
smb = md.surface_mass_balance;

tooth= [ [ones(400,1)*(smb') - 10]' [ones(400,1)*(smb')]' ];
smb=[ [ones(399,1)*(smb')]' smb  tooth tooth];

md.forcings.surface_mass_balance= smb;
md.forcings.surface_mass_balance(end+1,:)=[1:2000];

md=solve(md,TransientSolutionEnum);

%Fields and tolerances to track changes
field_names={'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1','SurfaceMassBalance1', ...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2','SurfaceMassBalance2', ...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3','SurfaceMassBalance3', ...
	'Vx4','Vy4','Vel4','Pressure4','Bed4','Surface4','Thickness4','SurfaceMassBalance4', ...
	'Vx5','Vy5','Vel5','Pressure5','Bed5','Surface5','Thickness5','SurfaceMassBalance5'};
field_tolerances={1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10,...
	1e-09,1e-09,1e-09,1e-10,1e-10,1e-10,1e-10,1e-10};
field_values={...
	PatchToVec(md.results.TransientSolution(400).Vx),...
	PatchToVec(md.results.TransientSolution(400).Vy),...
	PatchToVec(md.results.TransientSolution(400).Vel),...
	PatchToVec(md.results.TransientSolution(400).Pressure),...
	PatchToVec(md.results.TransientSolution(400).Bed),...
	PatchToVec(md.results.TransientSolution(400).Surface),...
	PatchToVec(md.results.TransientSolution(400).Thickness),...
	PatchToVec(md.results.TransientSolution(400).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(800).Vx),...
	PatchToVec(md.results.TransientSolution(800).Vy),...
	PatchToVec(md.results.TransientSolution(800).Vel),...
	PatchToVec(md.results.TransientSolution(800).Pressure),...
	PatchToVec(md.results.TransientSolution(800).Bed),...
	PatchToVec(md.results.TransientSolution(800).Surface),...
	PatchToVec(md.results.TransientSolution(800).Thickness),...
	PatchToVec(md.results.TransientSolution(800).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(1200).Vx),...
	PatchToVec(md.results.TransientSolution(1200).Vy),...
	PatchToVec(md.results.TransientSolution(1200).Vel),...
	PatchToVec(md.results.TransientSolution(1200).Pressure),...
	PatchToVec(md.results.TransientSolution(1200).Bed),...
	PatchToVec(md.results.TransientSolution(1200).Surface),...
	PatchToVec(md.results.TransientSolution(1200).Thickness),...
	PatchToVec(md.results.TransientSolution(1200).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(1600).Vx),...
	PatchToVec(md.results.TransientSolution(1600).Vy),...
	PatchToVec(md.results.TransientSolution(1600).Vel),...
	PatchToVec(md.results.TransientSolution(1600).Pressure),...
	PatchToVec(md.results.TransientSolution(1600).Bed),...
	PatchToVec(md.results.TransientSolution(1600).Surface),...
	PatchToVec(md.results.TransientSolution(1600).Thickness),...
	PatchToVec(md.results.TransientSolution(1600).SurfaceMassBalance),...
	PatchToVec(md.results.TransientSolution(2000).Vx),...
	PatchToVec(md.results.TransientSolution(2000).Vy),...
	PatchToVec(md.results.TransientSolution(2000).Vel),...
	PatchToVec(md.results.TransientSolution(2000).Pressure),...
	PatchToVec(md.results.TransientSolution(2000).Bed),...
	PatchToVec(md.results.TransientSolution(2000).Surface),...
	PatchToVec(md.results.TransientSolution(2000).Thickness),...
	PatchToVec(md.results.TransientSolution(2000).SurfaceMassBalance),...
	};
