#!/bin/bash
#generate html report from nightly.log output file

#get some variables
function today_date {
suffix=`date | awk '{printf("%s-%s-%s %s",$2,$3,$6,$4);}'` 
echo $suffix;
}
ISSM_RELEASE="issm";
today=`today_date`;
host_name=`hostname`;

#Process log for errors 
cat nightly.log | grep 'package: macayeal' > macayeal.log
cat nightly.log | grep 'package: ice' > ice.log
cat nightly.log | grep 'package: cielo_serial' > cielo_serial.log
cat nightly.log | grep 'package: cielo_parallel' > cielo_parallel.log
cat nightly.log | grep NIGHTLYRUNTERMINATEDCORRECTLY > check.log
cat nightly.log | grep ERROR | grep -v "PETSC ERROR"> errors.log
cat nightly.log | grep SUCCESS > success.log
cat errors.log success.log > tests.log
mail -s "Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today." mathieu.morlighem@jpl.nasa.gov < tests.log

cat <<END > report.html
<html>
<title>ISSM - Nightly run Report</title>
<body>

<style type="text/css">
	<!--
	body {
		width: 900px;
		background:none;
		font-family: Arial, Verdana, Tahoma;
		font-size: 14px;
		color: #404040;
		margin: auto;}
	h1 {
		margin-top:1em;
		background: transparent;
		color: #6495ed;
		font-size: 250%;
		text-align: center;
		}

	h2 {
		margin-top:1.5em;
		background: transparent;
		color: #6495ed;
		font-size: 200%;
		text-align: left;
		}

	.comment
		{white-space:pre-wrap;
		word-wrap:break-word;
		padding:4px;
		border:1px dashed #000000;
		background-color:#ffffdd}
	-->
</style>
<div>
<br>
<h1>ISSM Nightly run report</h1>
<br>
<pre class="comment">
host: $host_name
date: $today
release: $ISSM_RELEASE

remark: $(if [ `wc -l check.log | awk '{printf("%s",$1);}'`  = "0" ];
then
	echo "stopped before the end"
else
	echo "all test desks have been run"
fi
rm check.log) 
number of errors: $(wc -l errors.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';  rm errors.log)
number of success: $(wc -l success.log | awk '{printf("%s",$1);}')/$(wc -l tests.log | awk '{printf("%s",$1);}';rm success.log tests.log)</pre>
<hr>

$(for  package in "macayeal" "ice" "cielo_serial" "cielo_parallel"; do

	#enter title
	if [ $package == "macayeal" ]; then
		echo "<h2>MacAyeal package</h2>"
	fi
	if [ $package == "ice" ]; then
		echo "<h2>Ice package</h2>"
	fi
	if [ $package == "cielo_serial" ]; then
		echo "<h2>Cielo Serial package</h2>"
	fi
	if [ $package == "cielo_parallel" ]; then
		echo "<h2>Cielo Parallel package</h2>"
	fi

	#check that at least one test exists
	if [ `wc -l $package.log | awk '{printf("%s",$1);}'`  = "0" ]; then
		echo "&nbsp;&nbsp No test found."
	else

		echo "<table cellspacing="-1" width="900px">"
		echo "<tr> <th>Result</th> <th>Tolerance</th> <th>Test</th>  <th>Solution</th> <th>Field</th> </tr>"

		# go through the lines of $package.log
		for i in $(seq 1 1 `wc -l $package.log | awk '{printf("%s",$1);}'`); do 

			echo "<tr>"

			#see wether it is success or error (get color: red or green)
			if [ "`cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$i'o/ {printf("%s\n",$2);}';`" == "SUCCESS" ];  
			then 
				color="bgcolor=#ddffdd";
			else
				color="bgcolor=#ffdddd";
			fi

			#build html corresponding line
			cat $package.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$i'o/ {printf("<td '$color'>%s</td><td '$color'> %s%s%s</td><td '$color'> %s</td><td '$color'> %s</td><td '$color'> %s</td>",$2,$3,$4,$5,$8,$10,$14);}';
			echo "</tr>"
		done

		echo "</table>"
	fi
	rm $package.log
done)

	<br>
	<center><small></a><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</small></center>
</div>
END

echo Script has completed
