function md=BasinConstrain2(md,domain);
%BASINCONSTRAIN - constrain basin
%
%   Constrain basin using a constraint domain outline, 
%   to dirichlet boundary conditions.
%   constraindomain is an Argus domain outline file enclosing 
%   the geographical area of interest.
%
%   Usage: 
%      md=BasinConstrain(md,constraindomain)
%
%   Example:
%      md=BasinConstrain(md,'DomainOutline.exp');
%      md=BasinConstrain(md,'~Iceshelves.exp');

%now, flag nodes and elements outside the domain outline.
if ischar(domain),
	if isempty(domain),
		elementondomain=zeros(md.numberofelements,1);
		nodeondomain=zeros(md.numberofnodes,1);
		invert=0;
	elseif strcmpi(domain,'all')
		elementondomain=ones(md.numberofelements,1);
		nodeondomain=ones(md.numberofnodes,1);
		invert=0;
	else
		%make sure that we actually don't want the elements outside the domain outline!
		if strcmpi(domain(1),'~'),
			domain=domain(2:end);
			invert=1;
		else
			invert=0;
		end
		%ok, flag elements and nodes
		[nodeondomain elementondomain]=ContourToMesh(md.elements(:,1:3),md.x,md.y,domain,'element and node',2);
	end
	if invert,
		nodeondomain=~nodeondomain;
		elementondomain=~elementondomain;
	end
else
	error('BasinConstrain error message: domain type not supported yet');
end

%list of elements and nodes not on domain
nodenotondomain=find(~nodeondomain);
elementnotondomain=find(~elementondomain);

%all elements outside the constraint domain are equivalent to water. all nodes outside are spc'd.
md.spcvx(nodenotondomain)=md.vx_obs(nodenotondomain);
md.spcvy(nodenotondomain)=md.vy_obs(nodenotondomain);
md.elementonwater(elementnotondomain)=1;

%now, make sure all elements on water have nodes that are spc'd, otherwise, we'll get a singular problem.
pos=find(~md.elementonwater);
numpos=unique(md.elements(pos,:));
nodes=setdiff(1:1:md.numberofnodes,numpos);
md.spcvx(nodes)=md.vx_obs(nodes);
md.spcvy(nodes)=md.vy_obs(nodes);


%make sure icefronts that are completely spc'd are taken out:
free_segments=find((~isnan(md.spcvx(md.pressureload(:,1:2))) + ~isnan(md.spcvy(md.pressureload(:,1:2))))~=2);
md.pressureload=md.pressureload(free_segments,:);
