/*
 * CreateConstraintsDiagnosticHoriz.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticHoriz(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i,j;
	int count;
	
	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;
	int     node1,node2;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn & !iomodel->isstokes)goto cleanup_and_return;
	
	/*Spcs: fetch data: */
	IoModelFetchData(&iomodel->spcvx,NULL,NULL,iomodel_handle,"spcvx");
	IoModelFetchData(&iomodel->spcvy,NULL,NULL,iomodel_handle,"spcvy");
	IoModelFetchData(&iomodel->spcvz,NULL,NULL,iomodel_handle,"spcvz");
	IoModelFetchData(&iomodel->nodeonhutter,NULL,NULL,iomodel_handle,"nodeonhutter");
	IoModelFetchData(&iomodel->nodeonmacayeal,NULL,NULL,iomodel_handle,"nodeonmacayeal");
	if(iomodel->dim==3)IoModelFetchData(&iomodel->nodeonpattyn,NULL,NULL,iomodel_handle,"nodeonpattyn");
	if(iomodel->dim==3)IoModelFetchData(&iomodel->nodeonstokes,NULL,NULL,iomodel_handle,"nodeonstokes");
	IoModelFetchData(&iomodel->vertices_type,NULL,NULL,iomodel_handle,"vertices_type");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");

	/*Initialize counter: */
	count=0;
	
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			/*Start with adding spcs of coupling: zero at the border macayeal/pattyn for the appropriate dofs*/
			if ((int)iomodel->vertices_type[i]==MacAyealPattynApproximationEnum){
				/*If grionmacayeal, spc pattyn dofs: 3 & 4*/
					if ((int)iomodel->nodeonpattyn[i]){
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}

					}
					else if ((int)iomodel->nodeonmacayeal[i]){
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}

					}
					else _error_("if vertices_type is MacAyealPattyn, you shoud have nodeonpattyn or nodeonmacayeal");
			}
			/*Also add spcs of coupling: zero at the border pattyn/stokes for the appropriate dofs*/
			else if ((int)iomodel->vertices_type[i]==PattynStokesApproximationEnum){
				/*If grion,pattyn spc stokes dofs: 3 4 & 5*/
					if ((int)iomodel->nodeonpattyn[i]){
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,5,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}

					}
					else if ((int)iomodel->nodeonstokes[i]){ //spc pattyn nodes: 1 & 2
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvz[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,5,iomodel->spcvz[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
					}
					else _error_("if vertices_type is PattynStokes, you shoud have nodeonpattyn or nodeonstokes");
			}
			/*Also add spcs of coupling: zero at the border pattyn/stokes for the appropriate dofs*/
			else if ((int)iomodel->vertices_type[i]==MacAyealStokesApproximationEnum){
				/*If grion,pattyn spc stokes dofs: 3 4 & 5*/
					if ((int)iomodel->nodeonmacayeal[i]){
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,5,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}

					}
					else if ((int)iomodel->nodeonstokes[i]){ //spc macayeal nodes: 1 & 2
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,0,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
						count++;
						if (!isnan(iomodel->spcvx[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvy[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
						if (!isnan(iomodel->spcvz[i])){
							constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,5,iomodel->spcvz[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
							count++;
						}
					}
					else _error_("if vertices_type is MacAyealStokes, you shoud have nodeonmacayeal or nodeonstokes");
			}
			/*Now add the regular spcs*/
			else{
				if (!isnan(iomodel->spcvx[i]) || (int)iomodel->nodeonhutter[i]){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,iomodel->spcvx[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
					count++;
				}
				
				if (!isnan(iomodel->spcvy[i]) || (int)iomodel->nodeonhutter[i]){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,iomodel->spcvy[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
					count++;
				}
				if (!isnan(iomodel->spcvz[i]) && ((int)iomodel->vertices_type[i]==StokesApproximationEnum ||  ((int)iomodel->vertices_type[i]==NoneApproximationEnum))){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,iomodel->spcvz[i]/iomodel->yts,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
					count++;
				}
				if ((int)iomodel->vertices_type[i]==NoneApproximationEnum){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,iomodel->g*iomodel->rho_ice*(iomodel->surface[i]-iomodel->z[i])/iomodel->stokesreconditioning,DiagnosticHorizAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
					count++;
				}
			}
		}
	}
	  
	/*Free data: */
	xfree((void**)&iomodel->spcvx);
	xfree((void**)&iomodel->spcvy);
	xfree((void**)&iomodel->spcvz);
	xfree((void**)&iomodel->nodeonhutter);
	xfree((void**)&iomodel->nodeonmacayeal);
	xfree((void**)&iomodel->nodeonpattyn);
	xfree((void**)&iomodel->nodeonstokes);
	xfree((void**)&iomodel->vertices_type);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->z);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}
