/*
 * CreateConstraintsBalancevelocities.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsBalancevelocities(Constraints** pconstraints, IoModel* iomodel,FILE* iomodel_handle){

	/*Intermediary*/
	int i;
	int count=0;
	
	/*Output*/
	Constraints* constraints = NULL;
	Spc*    spc  = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Fetch data: */
	IoModelFetchData(&iomodel->spcvx,NULL,NULL,iomodel_handle,"spcvx");
	IoModelFetchData(&iomodel->spcvy,NULL,NULL,iomodel_handle,"spcvy");

	count=1; //matlab indexing
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i])){

			if (!isnan(iomodel->spcvx[i]) && !isnan(iomodel->spcvy[i])){ //spc if vx and vy are constrained

				/*This node needs to be spc'd: */
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,
								pow( pow(iomodel->spcvx[i],2.0) + pow(iomodel->spcvy[i],2.0) ,0.5),BalancevelocitiesAnalysisEnum));
				count++;
			}
		} //if((my_vertices[i]))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvx);
	xfree((void**)&iomodel->spcvy);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
