/* \file macros.h
 * \brief: global macros used in the whole code
 */

/*Header {{{1*/
#ifndef _MACROS_H_
#define _MACROS_H_

#include "./typedefs.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
/*}}}*/

/* _printf_ {{{1*/
/*Printing macro: only cpu number 0 */
#define _printf_(flag,...) do { if(flag) PrintfFunction(__VA_ARGS__); }while (0)
/*}}}*/
/* _error_ {{{1*/
/*Error exception macro*/
#ifdef _INTEL_WIN_
#define _error_(...)\
  throw ErrorException(exprintf(__VA_ARGS__))
#else
#define _error_(...)\
  throw ErrorException(__FILE__,__func__,__LINE__,exprintf(__VA_ARGS__))
#endif
/*}}}*/
/* _assert_ {{{1*/
/*Assertion macro: do nothing if macro _ISSM_DEBUG_ undefined*/
#ifdef _ISSM_DEBUG_ 
#define _assert_(statement)\
  if (!(statement)) _error_("Assertion \"%s\" failed, please report bug to ISSM developers",#statement)
#else
#define _assert_(ignore)\
  ((void) 0)
#endif
/*}}}*/
/* MODULEBOOT/MODULEEND {{{1*/
/*The following macros hide the error exception handling in a matlab module. Just put 
 * MODULEBOOT(); and MODULEEND(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/
#ifdef _SERIAL_

#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		mexErrMsgTxt(""); \
	}\
	catch (exception& e) {\
		_printf_(true,"Standard exception: %s\n",e.what());\
		mexErrMsgTxt(" ");\
	}

#else 

#define MODULEBOOT(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		return 1;\
	}\
	catch (exception& e) {\
		_printf_(true,"Standard exception: %s\n",e.what());\
		return 1;\
	}
#endif
/*}}}*/

#endif
