function femmodel=solver_couplingstokes_nonlinear(femmodel,conserve_loads)
%SOLVER_COUPLINGSTOKES_NONLINEAR - core solver of coupling run
%
%   Usage:
%      [femmodel]=solver_couplingstokes_nonlinear(femmodel,conserve_loads)

	%initialize solution vector
	converged=0; count=1;

	%First get ug=ug_horiz+ug_vert
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
	ug_horiz=GetSolutionFromInputs(femmodel.elements, femmodel.nodes, femmodel.vertices, femmodel.loads, femmodel.materials, femmodel.parameters);
	uf_horiz=Reducevectorgtof( ug_horiz, femmodel.nodes,femmodel.parameters);

	while(~converged),

		%First compute the horizontal velocity
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
		analysis_type=femmodel.parameters.AnalysisType;

		%Update the solution to make sure that vx and vxold are similar
		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ug_horiz);

		%save pointer to old velocity
		old_ug_horiz=ug_horiz;
		old_uf_horiz=uf_horiz;

		[K_ff_horiz,K_fs_horiz,p_f_horiz,d_f_horiz,kmax_horiz]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		ys=CreateNodalConstraints(femmodel.nodes,analysis_type);
		p_f_horiz = Reduceload( p_f_horiz, K_fs_horiz, ys);

		uf_horiz=Solver(K_ff_horiz,p_f_horiz,old_uf_horiz,d_f_horiz,femmodel.parameters);
		ug_horiz= Mergesolutionfromftog( uf_horiz, ys, femmodel.nodes,femmodel.parameters); 

		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ug_horiz);

		%Figure out if convergence have been reached
		converged=convergence(K_ff_horiz,p_f_horiz,uf_horiz,old_uf_horiz,femmodel.parameters);

		%Then compute vertical velocity
		femmodel=SetCurrentConfiguration(femmodel,DiagnosticVertAnalysisEnum);
		analysis_type=femmodel.parameters.AnalysisType;

		[K_ff_vert,K_fs_vert,p_f_vert,d_f_vert,kmax_vert]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		ys=CreateNodalConstraints(femmodel.nodes,analysis_type);
		p_f_vert = Reduceload( p_f_vert, K_fs_vert, ys);

		uf_vert=Solver(K_ff_vert,p_f_vert,[],d_f_vert,femmodel.parameters);
		ug_vert= Mergesolutionfromftog( uf_vert, ys, femmodel.nodes,femmodel.parameters); 

		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ug_vert);

	end
end
