function femmodel=solver_adjoint_linear(femmodel)
%SOLVER_LINEAR - core solver of any linear solution sequence
%
%   Usage:
%      femmodel =solver_adjoint_linear(femmodel)

	%Get parameters
	analysis_type=femmodel.parameters.AnalysisType;

	[K_ff,K_fs,p_f,df,kmax]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	ys=CreateNodalConstraints(femmodel.nodes,analysis_type);
	p_f = Reduceload( p_f, K_fs, ys,true);

	issmprintf(VerboseSolver(),'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	u_f=Solver(K_ff,p_f,[],df,femmodel.parameters);
	u_g= Mergesolutionfromftog( u_f, femmodel.ys, femmodel.nodes,femmodel.parameters,true); 

	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,u_g);
