/*\file UpdateSpcs.c
 *\brief: update single point constraints inside nodes out of constrain vector ys
 */

#include "./UpdateSpcs.h"


void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;
	Vec ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateSpcsUsage);

	/*Input datasets: */
	FetchData((DataSet**)&nodes,NODESIN);
	FetchParams((Parameters**)&parameters,PARAMETERS);
	FetchData(&ys,YS);
	
	/*!Generate internal degree of freedom numbers: */
	UpdateSpcsx(nodes,parameters,ys);

	/*write output datasets: */
	WriteData(NODESOUT,nodes);

	/*Free ressources: */
	delete nodes;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void UpdateSpcsUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: m.nodes=%s(m.nodes,m.parameters,ys);\n",__FUNCT__);
	_printf_(true,"\n");
}
