/*\file Reducevectorgtos.c
 *\brief: reduce g set vector to s set vector (set of single point constraints)
 */

#include "./Reducevectorgtos.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec yg=NULL;
	Nodes* nodes=NULL;
	Parameters* parameters=NULL;

	/* output datasets: */
	Vec ys=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ReducevectorgtosUsage);

	/*Input datasets: */
	FetchData(&yg,YG);
	FetchData((DataSet**)&nodes,NODES);
	FetchParams(&parameters,PARAMETERS);

	/*!Reduce vector: */
	Reducevectorgtosx(&ys,yg,nodes,parameters);

	/*write output datasets: */
	WriteData(YS,ys);

	/*Free ressources: */
	delete nodes;
	delete parameters;
	VecFree(&yg);
	VecFree(&ys);

	/*end module: */
	MODULEEND();
}

void ReducevectorgtosUsage(void)
{
	_printf_(true,"\n");
	_printf_(true,"   usage: ys = %s(yg,nodes,parameters);\n",__FUNCT__);
	_printf_(true,"\n");
}
