/*!\file UpdateSpcsx
 * \brief module to update single point constraints  out of new spc vector, for next time step.
 */

#include "./UpdateSpcsx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateSpcsx(Nodes* nodes,Parameters* parameters,Vec ys){
	
	int i;
	int analysis_type;
	double* ys_serial=NULL;

	/*retrieve parameters: */
	parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	if(nodes->NumberOfNodes(analysis_type)){ 

		/*serialize ys, so nodes can index into it: */
		VecToMPISerial(&ys_serial,ys);

		/*Go through all nodes, and ask them to retrieve values from ys and then update their spc values :*/
		for(i=0;i<nodes->Size();i++){

			Node* node=(Node*)nodes->GetObjectByOffset(i);

			/*Check that this node corresponds to our analysis currently being carried out: */
			if (node->InAnalysis(analysis_type)){

				/*For this object, reset values of spc fields in the node: */
				node->UpdateSpcs(ys_serial);
			}
		}
	}

	/*Free ressources:*/
	xfree((void**)&ys_serial);
}
